/***************************************
 Blink stuff, handle other timed events
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

/*** GnomeICU header files */
#include "common.h"

/*** Local function declarations ***/
void set_widget_color(GtkWidget* w, GdkColor rgb);

/*** Global functions ***/
guint flash_messages( void )
{
	static char flash = 0, prev_status = 0;
	int have_message = 0;
	char wintitle[256];

	GtkWidget *clist;

	GSList *contact;

	GdkColor red, black;

	gboolean have_online_msg = FALSE, have_offline_msg = FALSE;
	static gboolean had_online_msg = FALSE, had_offline_msg = FALSE;
	gboolean have_not_msg = FALSE;
	static gboolean had_not_msg = FALSE;

	gchar *title;

	flash = !flash;

	red.red = 32000;
	red.green = 0;
	red.blue = 0;
	red.pixel = 32000 * 65536;
	
	black.red = 0;
	black.green = 0;
	black.blue = 0;
	black.pixel = 0;

	if( time( NULL ) > next_resend )
		Do_Resend();

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->chat_away == -1 )
		{
			sprintf( wintitle, _("GnomeICU: %s, %s"), ( strlen( our_info->nick ) ? our_info->nick : _("User") ), ((CONTACT_PTR)contact->data)->nick );
			gtk_window_set_title( GTK_WINDOW( ((CONTACT_PTR)contact->data)->chat_window ),
			                      wintitle );
			((CONTACT_PTR)contact->data)->chat_away = 0;
		}
		
		if( ((CONTACT_PTR)contact->data)->chat_away > 0 )
		{
			if( ((CONTACT_PTR)contact->data)->chat_sok )
			{
				int time_away = time(NULL) - ((CONTACT_PTR)contact->data)->chat_away;
				sprintf( wintitle, _("GnomeICU: %s, %s: User is away [%02d:%02d:%02d]"),
				         ( strlen( our_info->nick ) ? our_info->nick : _("User") ), ((CONTACT_PTR)contact->data)->nick,
				         time_away / 3600, (time_away % 3600) / 60,
				         time_away % 60 );
				gtk_window_set_title( GTK_WINDOW( ((CONTACT_PTR)contact->data)->chat_window ),
				                      wintitle );
			}
		}

		if( g_slist_length( ((CONTACT_PTR)contact->data)->stored_messages ) )
		{
			if( ((CONTACT_PTR)contact->data)->inlist == FALSE )
			{
				clist = MainData->lb_userwin_notinlist;
				have_not_msg = TRUE;
			}
			else if( ((CONTACT_PTR)contact->data)->status == STATUS_OFFLINE )
			{
				clist = MainData->lb_userwin_offline;
				have_offline_msg = TRUE;
			}
			else
			{
				clist = MainData->lb_userwin_online;
				have_online_msg = TRUE;
			}

			have_message = TRUE;
			switch( flash )
			{
				case FALSE:
					gtk_clist_set_pixmap( GTK_CLIST( clist ),
					                      ((CONTACT_PTR)contact->data)->lb_index, 0,
					                      icon_blank_pixmap,
					                      icon_blank_bitmap );
					break;
				case TRUE:
					switch( ((STORED_MESSAGE_PTR)((CONTACT_PTR)contact->data)->stored_messages->data)->type )
					{
						case MESSAGE_TEXT:
						default:
							gtk_clist_set_pixmap( GTK_CLIST( clist ),
							                      ((CONTACT_PTR)contact->data)->lb_index, 0,
							                      icon_message_pixmap,
							                      icon_message_bitmap );
							break;
						case MESSAGE_CHAT_REQ:
							gtk_clist_set_pixmap( GTK_CLIST( clist ),
							                      ((CONTACT_PTR)contact->data)->lb_index, 0,
							                      icon_chat_pixmap,
							                      icon_chat_bitmap );
							break;
						case MESSAGE_URL:
							gtk_clist_set_pixmap( GTK_CLIST( clist ),
							                      ((CONTACT_PTR)contact->data)->lb_index, 0,
							                      icon_url_pixmap,
							                      icon_url_bitmap );
							break;
						case MESSAGE_CONT_LIST:
							gtk_clist_set_pixmap( GTK_CLIST( clist ),
							                      ((CONTACT_PTR)contact->data)->lb_index, 0,
							                      icon_contact_pixmap,
							                      icon_contact_bitmap );
							break;
						case MESSAGE_AUTH_REQ:
						case MESSAGE_USER_ADD:
						case MESSAGE_USER_AUTHD:
							gtk_clist_set_pixmap( GTK_CLIST( clist ),
							                      ((CONTACT_PTR)contact->data)->lb_index, 0,
							                      icon_auth_pixmap,
							                      icon_auth_bitmap );
							 break;
						case MESSAGE_FILE_REQ:
							gtk_clist_set_pixmap( GTK_CLIST( clist ),
							                      ((CONTACT_PTR)contact->data)->lb_index, 0,
							                      icon_file_pixmap,
							                      icon_file_bitmap );
							break;
					}
					break;
			}
		}
		contact = contact->next;
	}

	if( have_message )
	{
		if( flash )
			applet_update( Current_Status, icon_offline_pixmap );
		else
			applet_update( Current_Status, NULL );
	}

	if( have_message != prev_status )
	{
		prev_status = have_message;
		title = g_strdup_printf( "%s%s", WindowTitle, (have_message ? _(": Msgs") : "" ) );
		gtk_window_set_title( GTK_WINDOW( MainData->window ), title );
		g_free( title );
	}

	if( had_online_msg != have_online_msg )
	{
		had_online_msg = have_online_msg;
		if( have_online_msg )
			set_widget_color( MainData->head_online, red );
		else
			set_widget_color( MainData->head_online, black );
	}

	if( had_offline_msg != have_offline_msg )
	{
		had_offline_msg = have_offline_msg;
		if( have_offline_msg )
			set_widget_color( MainData->head_offline, red );
		else
			set_widget_color( MainData->head_offline, black );
	}

	if( had_not_msg != have_not_msg )
	{
		had_not_msg = have_not_msg;
		if( have_not_msg )
			set_widget_color( MainData->head_notinlist, red );
		else
			set_widget_color( MainData->head_notinlist, black );
	}

	return TRUE;
}

/*** Local functions ***/
void set_widget_color(GtkWidget* w, GdkColor rgb)
{
	GtkStyle* style;

	gtk_widget_ensure_style(w);
	style = gtk_style_copy(w->style);
	style->fg[ GTK_STATE_NORMAL ] = rgb;
	gtk_widget_set_style(w, style);

	gtk_style_unref(style);
}
