/*********************************************************************
 *     main.c - a small wrapper for the dsp code.
 *      Copyright (C) 2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#include<stdio.h>
#include "compiler.h"

int main(int argc, char *argv[])
{
	FILE *fp;
	int i;

	/* init gpr's */
	for(i=0;i<GPR_TOTAL;i++) {
		gpr_usage[i] = GPR_USAGE_NONE;
		gpr_value[i] = 0;
	}

	/* init tram */
	for(i=0;i<TRAM_LINES_TOTAL;i++) {
                tram_usage[i] = TRAM_LINE_USAGE_NONE;
                tram_address_value[i] = 0;
		tram_data_value[i] = 0;
        }

	/* init tram block */

	for(i=0;i<TRAM_BLOCKS_TOTAL;i++) {
                tram_block[i].type = TRAM_BLOCK_TYPE_EMPTY;
                tram_block[i].tram_line_num = 0;
        }

	ip = 0;

	{
#include "dsp_file"
	}

#ifdef DEBUG
	for (i = 0; i < DSP_CODE_SIZE / 2; i++)
		printf("0x%03x   0x%08x   0x%08x\n", i, dsp_code[i * 2], dsp_code[i * 2 + 1]);
#endif

	fp = fopen(argv[1], "w");

	/* write header */

	/* write binary code */

	for (i = 0; i < 4 * DSP_CODE_SIZE; i++)
		fprintf(fp, "%c", ((char *) dsp_code)[i]);

	fclose(fp);
	return 0;
}
