/**
 * DCOP interface for the background manager.
 */

#ifndef __KBackgroundIface_h__
#define __KBackgroundIface_h__

#include <dcopobject.h>

class KBackgroundIface : virtual public DCOPObject
{
    K_DCOP
public:

k_dcop:
    /** Reread the configuration */
    virtual void configure() = 0;

    /** 
     * Change desktop. Normally, this is handled using the NET protocol so
     * you shouldn't need this. 
     * @parm desk The desktop to change to. 1 <= desktop <= 8
     * */
    virtual void changeDesktop(int desk) = 0;

    /** Enable/disable export of the background pixmap. */
    virtual void setExport(int xport) = 0;

    /** Enable/disable common desktop background. */
    virtual void setCommon(int common) = 0;
};

#endif // __KBackgroundIface_h__
