/***************************************************************************
                          ktablesview.h  -  description
                             -------------------
    begin                : Mi Jl  7 17:04:49 CEST 1999

    copyright            : (C) 1999 by rn E. Hansen
    email                : hanseno@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KTABLESVIEW_H
#define KTABLESVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>

#include <openparts_ui.h>
#include <koFrame.h>
#include <koView.h>

#include <kdbrecordview.h>

#include "ktables.h"

class KtablesDoc;
class kdtDataSet;
class KtablesServer;
class TableSelect;
class QueryDialog;

/** The KtablesView class provides the view widget for the KtablesApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KtablesView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the KtablesApp class to manipulate and display
	* the document structure provided by the KtablesDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/
class KtablesView : public kdbRecordView,
										virtual public KoViewIf,
										virtual public Ktables::View_skel
{
  Q_OBJECT

public:
  KtablesView(kdbDataSet *,KtablesDoc *,QWidget* parent = 0, const char* name=0);
  ~KtablesView();

  virtual void cleanUp();
  bool printDlg();

  // IDL slots
  void cutSelection();
  void copySelection();
  void paste();

  void selectServer();
  void selectTables();
  void selectQuery();

  void setupView();

  void insertRow();
  void removeRow();
  void commit();
  void reScanTable();

  void helpUsing();

	KtablesDoc* getDocument() const;
	
	virtual void setTable(const QString&);
		
protected:
  virtual void init();
  virtual bool event( const QCString & , const CORBA::Any& );
  virtual bool mappingCreateMenubar( OpenPartsUI::MenuBar_ptr );
  virtual bool mappingCreateToolbar( OpenPartsUI::ToolBarFactory_ptr );
  virtual void newView();

  // Variables
	OpenPartsUI::Menu_var    m_vMenuEdit;
	OpenPartsUI::Menu_var    m_vMenuQuery;
	OpenPartsUI::Menu_var    m_vMenuHelp;
	OpenPartsUI::ToolBar_var m_vToolBarQuery;
	
	long int m_idButtonQuery_server;
	
	long int m_idMenuEdit_cut;
	long int m_idMenuEdit_copy;
	long int m_idMenuEdit_paste;
	long int m_idMenuEdit_insert;
	long int m_idMenuEdit_remove;
	long int m_idMenuEdit_commit;
	long int m_idMenuEdit_discard;
	
	long int m_idMenuQuery_server;
	long int m_idMenuQuery_tables;
	long int m_idMenuQuery_query;
	long int m_idMenuQuery_tuples;
	
	KtablesDoc    *m_pDoc;
	KtablesServer *_selectServer;
	TableSelect   *_tableSelect;
	QueryDialog   *_queryTree;
	
signals:
	void signalMsg(const char *);
	void serverOpened();
	void tableActive();
	
protected slots:
	virtual void tablesSelectedOk();
	virtual void serverOpenedOk();
	virtual void slotUpdateView();
	
};

#endif // KTABLESVIEW_H






































