/* -*- C++ -*-
 * This file declares a widget to edit string lists.
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.1 $
 */
  
#ifndef StringListEditWidget_included
#define StringListEditWidget_included

#include <qstringlist.h>
#include <qwidget.h>

class QPushButton;
class QLineEdit;
class QListBox;

class StringListEditWidget : public QWidget
{
  // ############################################################################
  Q_OBJECT
  // ----------------------------------------------------------------------------
public:
  StringListEditWidget(QWidget* parent=0, const char* name=0);
  virtual ~StringListEditWidget();
  QSize sizeHint() const;
  void setStrings(const QStringList& strings);
  void getStrings(QStringList& result);
  // ----------------------------------------------------------------------------
public slots:
  void initializeGeometry();
  // ----------------------------------------------------------------------------
protected slots:
  virtual void downPressed();
  virtual void itemSelected(int);
  virtual void itemChanged(const QString&);
  virtual void newItem();
  virtual void deletePressed();
  virtual void upPressed();
  // ----------------------------------------------------------------------------
protected:
  void resizeEvent(QResizeEvent*);
  void enableButtons();
  QListBox* lbStrings;
  QPushButton* buttonUp;
  QPushButton* buttonDown;
  QPushButton* buttonDelete;
  QLineEdit* leLine;
  QPushButton* buttonNew;
  // ############################################################################
};

#endif // StringListEditWidget_included




