/* This file implements kabs main function.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.6 $
 */

#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kmessagebox.h>
#include <iostream.h>
#include <kabapi.h>
#include <kaboutdata.h>
#include "kab_topwidget.h"
#include "look_businesscard.h"


static const char *description = 
	I18N_NOOP("KDE Addressbook");

static const char *version = "v2.0pre";

int main(int argc, char** argv)
{
  KAboutData aboutData( "kab", I18N_NOOP("KAB"),
    version, description, KAboutData::License_GPL,
    "(c) Mirko Sucker");
  //  aboutData.addAuthor("",0, "");
  KCmdLineArgs::init( argc, argv, &aboutData );

  KApplication app;
  TopLevelWidget widget;
  KMessageBox::information
    (0,
     i18n("<qt>Version 2 of the KDE address book is not compatible "
	  "with the previous one. "
	  "To protect your address database, a new file will be used. "
	  "Run <b>File->Import->KDE 1 addressbook</b> to use your old "
	  "database with the new version.</qt>"),
     i18n("new format"),
     "kab_new_version_incompatibility");
  app.setMainWidget(&widget);
  widget.resize(480, 320);
  widget.show();
  return app.exec();
}

