/****************************************************
 * SQLGetPrivateProfileString
 *
 * Mostly used with odbc.ini files but can be used for odbcinst.ini
 *
 * IF pszFileName[0] == '/' THEN
 *		use pszFileName
 * ELSE
 *		use _odbcinst_ConfigModeINI() to get the complete file name for the current mode.
 *
 **************************************************
 * This code was created by Peter Harvey @ CodeByDesign.
 * Released under LGPL 28.JAN.99
 *
 * Contributions from...
 * -----------------------------------------------
 * Peter Harvey		- pharvey@codebydesign.com
 **************************************************/
#include <odbcinstext.h>

int SQLGetPrivateProfileString(	LPCSTR	pszSection,
								LPCSTR	pszEntry,
								LPCSTR	pszDefault,
								LPSTR	pRetBuffer,
								int		nRetBuffer,
								LPCSTR	pszFileName
								)
{
	HINI	hIni;
	int		nBufPos			= 0;
	char	szValue[INI_MAX_PROPERTY_VALUE+1];
	char	szFileName[FILENAME_MAX+1];
	UWORD	nConfigMode;
    int     ini_done = 0;

	*pRetBuffer = '\0';

	/* SANITY CHECKS */
	if ( pRetBuffer == NULL || nRetBuffer < 2 )
	{
        inst_logPushMsg( __FILE__, __FILE__, __LINE__, LOG_CRITICAL, ODBC_ERROR_GENERAL_ERR, "" );
		return -1;
	}
	if ( pszSection != NULL && pszEntry != NULL && pszDefault == NULL )
	{
        inst_logPushMsg( __FILE__, __FILE__, __LINE__, LOG_CRITICAL, ODBC_ERROR_GENERAL_ERR, "" );
		return -1;
	}

	/*****************************************************
	 * SOME MS CODE (ie some drivers) MAY USE THIS FUNCTION TO GET ODBCINST INFO SO...
	 *****************************************************/
	if ( pszFileName != NULL )
	{
		if ( strstr( pszFileName, "odbcinst" ) || strstr( pszFileName, "ODBCINST" ) )
			return _SQLGetInstalledDrivers(	pszSection,	pszEntry, pszDefault, pRetBuffer, nRetBuffer );
	}

	/*****************************************************
	 * GATHER ALL RELEVANT DSN INFORMATION INTO AN hIni
	 *****************************************************/
	nConfigMode		= ODBC_BOTH_DSN;
	SQLGetConfigMode( &nConfigMode );
	nBufPos 		= 0;
    szFileName[0]	= '\0';
	switch ( nConfigMode )
	{
	case ODBC_BOTH_DSN:
        if ( _odbcinst_UserINI( szFileName, TRUE ))
        {
            if ( iniOpen( &hIni, szFileName, '#', '[', ']', '=', TRUE ) 
                    == INI_SUCCESS )
            {
                ini_done = 1;
            }
        }
        _odbcinst_SystemINI( szFileName, TRUE );
        if ( !ini_done )
        {
            if ( iniOpen( &hIni, szFileName, '#', '[', ']', '=', TRUE ) 
                    != INI_SUCCESS )
            {
                inst_logPushMsg( __FILE__, __FILE__, __LINE__, 
                        LOG_CRITICAL, ODBC_ERROR_COMPONENT_NOT_FOUND, "" );
                return -1;
            }
        }
		iniAppend( hIni, szFileName );
		break;

	case ODBC_USER_DSN:
		_odbcinst_UserINI( szFileName, TRUE );
		if ( iniOpen( &hIni, szFileName, '#', '[', ']', '=', TRUE ) 
                != INI_SUCCESS )
		{
			inst_logPushMsg( __FILE__, __FILE__, __LINE__, LOG_CRITICAL, 
                    ODBC_ERROR_COMPONENT_NOT_FOUND, "" );
			return -1;
		}
		break;

	case ODBC_SYSTEM_DSN:
		_odbcinst_SystemINI( szFileName, TRUE );
		if ( iniOpen( &hIni, szFileName, '#', '[', ']', '=', TRUE ) 
                != INI_SUCCESS )
		{
			inst_logPushMsg( __FILE__, __FILE__, __LINE__, LOG_CRITICAL, 
                    ODBC_ERROR_COMPONENT_NOT_FOUND, "" );
			return -1;
		}
		break;

	default:
        inst_logPushMsg( __FILE__, __FILE__, __LINE__, LOG_CRITICAL, 
                ODBC_ERROR_GENERAL_ERR, "Invalid Config Mode" );
		return -1;
	}

	/*****************************************************
	 * EXTRACT SECTIONS
	 *****************************************************/
	if ( pszSection == NULL )
	{
		_odbcinst_GetSections( hIni, pRetBuffer, nRetBuffer, &nBufPos );
	}
	/*****************************************************
	 * EXTRACT ENTRIES
	 *****************************************************/
	else if ( pszEntry == NULL )
	{
		_odbcinst_GetEntries( hIni, pszSection, pRetBuffer, nRetBuffer, &nBufPos );
	}
	/*****************************************************
	 * EXTRACT AN ENTRY
	 *****************************************************/
	else
	{
		if ( pszSection == NULL || pszEntry == NULL || pszDefault == NULL )
		{
			inst_logPushMsg( __FILE__, __FILE__, __LINE__, LOG_CRITICAL, ODBC_ERROR_GENERAL_ERR, "" );
			return -1;
		}

		/* TRY TO GET THE ONE ITEM MATCHING Section & Entry */
		if ( iniPropertySeek( hIni, (char *)pszSection, (char *)pszEntry, "" ) != INI_SUCCESS )
		{
            /*
             * (NG) this seems to be ignoring the length of pRetBuffer !!!
             */
			/* strncpy( pRetBuffer, pszDefault, INI_MAX_PROPERTY_VALUE ); */
			strncpy( pRetBuffer, pszDefault, nRetBuffer );
            pRetBuffer[ nRetBuffer - 1 ] = '\0';
		}
		else
		{
			iniValue( hIni, szValue );
			strncpy( pRetBuffer, szValue, nRetBuffer );
            nBufPos = strlen( szValue ) + 2;
		}
	}

	iniClose( hIni );

	return nBufPos;
}
														

