/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _LDAPSEARCHJOB_H_
#define _LDAPSEARCHJOB_H_


#include <kio/job.h>

class LdapSite;


struct LdapAttribute
{
    QString key;
    QString value;
};

typedef QValueList<LdapAttribute> LdapItem;
typedef QValueList<LdapAttribute>::ConstIterator LdapItemConstIterator;


class LdapSearchJob : public KIO::TransferJob
{
    Q_OBJECT

public:
    LdapSearchJob(LdapSite *site, const QString &searchtext);
    ~LdapSearchJob();

protected:
    virtual void parseItem(const LdapItem &item) = 0;
    LdapSite *m_site;

private slots:
    void gotData(KIO::Job *, const QByteArray &data);
    void slotFinished();

private:
    QByteArray makeArgs(LdapSite *site, const QString &querytext);
    void dumpEntry();
    QString m_buf;
    QStringList entry;
};

 
#endif 
