#include "kbiff.h"
#include <kwm.h>
#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "setupdlg.h"
#include "Trace.h"


static const char *description = 
	I18N_NOOP("Full featured mail notification utility.");

static const char *version = "v2.3.11cvs";

static KCmdLineOptions option[] =
{
   { "debug", I18N_NOOP("Enable debug output"), 0 },
   { "secure", I18N_NOOP("Run in secure mode"), 0 },
   { "profile <profile>", I18N_NOOP("Use 'profile'"), 0 },
   { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	KAboutData aboutData( "kbiff", I18N_NOOP("KBiff"),
		version, description, KAboutData::License_GPL,
		"(c) 1999-2000, Kurt Granroth");
	aboutData.addAuthor("Kurt Granroth",0, "granroth@kde.org");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions(option);

	KApplication app;
	KBiff kbiff(app.dcopClient());
	KBiffSetup* setup = 0;
	bool is_secure    = false;
	bool have_profile = false;
	QString profile;

	app.setMainWidget(&kbiff);

        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	if (args->isSet("debug"))
		TRACEON(true);

	is_secure = args->isSet("secure");

	if (args->isSet("profile"))
	{
		profile = args->getOption("profile");
		have_profile = true;
	}

	args->clear();

TRACEINIT("main()");

	// restore this app if it is
	if (kapp->isRestored())
	{
		TRACE("isRestored()");
		kbiff.readSessionConfig();
	}
	else
	{
		TRACE("notRestored()");
		// do we have the profile option?
		if (have_profile)
        {
			setup = new KBiffSetup(profile, is_secure);

			QObject::connect(setup, SIGNAL(signalPlaySound(const QString&)),
	                         &kbiff, SLOT(slotPlaySound(const QString&)));

        }
		else
		{
			setup = new KBiffSetup();

			QObject::connect(setup, SIGNAL(signalPlaySound(const QString&)),
	                         &kbiff, SLOT(slotPlaySound(const QString&)));

			if (!setup->exec())
			{
				delete setup;
				return 0;
			}
		}
		kbiff.processSetup(setup, true);

	}

	// check if we are docked (only if restored)
	if (kbiff.isDocked())
	{
		kapp->setTopWidget(new QWidget);
		KWM::setDockWindow(kbiff.winId());
	}
	else
		kapp->setTopWidget(&kbiff);

//WABA: Session management changes
#if 1
#warning Session management is broken
#else
	// enable session management
	kapp->enableSessionManagement();
#endif
	kbiff.show();

	return app.exec();
}
