/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _FTPRESULTS_H_
#define _FTPRESULTS_H_


#include <qlistview.h>
class FtpResultView;


class FtpResultView : public QListView
{
    Q_OBJECT
    
public:
    FtpResultView( QWidget *parent=0, const char *name=0 );

    void insertItem(const QString &host, const QString &path,
                    const QString &size, const QString &date);
    
signals:
    void urlActivated(const QString &url);

protected slots:
    void itemActivated(QListViewItem *item);

protected:
    virtual void contentsMouseMoveEvent(QMouseEvent *e);
    virtual QSizePolicy sizePolicy () const  
        { return QSizePolicy(QSizePolicy::MinimumExpanding,
                             QSizePolicy::MinimumExpanding); }    
};

#endif
