/* $Id: kmainwidget.h,v 1.28 2000/04/21 14:06:56 koss Exp $
   $Log: kmainwidget.h,v $
   Revision 1.28  2000/04/21 14:06:56  koss
   Little GUI reorganization for new individual transfer dialogs.

   Revision 1.27  2000/04/20 19:11:14  koss
   Some renaming for consistence :
      ConfigDlg to DlgTransferConfig.
      PreferencesDlg to DlgPreferences.
   Added dlgProgress as a new individual progress dialog.
   Fixed application quitting.
   Fixed action update after job cancelation.

   Revision 1.26  2000/04/11 20:42:19  koss
   Ported to XML framework.

   Revision 1.25  2000/04/10 11:56:20  koss
   Exposed some actions for LogWindow and PreferencesDlg.
   various fixes.

   Revision 1.24  2000/04/08 16:24:12  koss
   ported to KAudioPlayer

   Revision 1.23  2000/03/26 14:26:10  koss
   KAction stuff should work now.

   Revision 1.22  2000/03/12 12:22:52  koss
   Some conversion to KAction framework.

   Revision 1.21  2000/03/04 14:56:42  koss
   Fixed KFileDialog stuff : QString -> KURL, getOpenFileName ->
   getOpenURL etc.
   Now Caitoo at least compiles ( and even works on local files :-) ).
   Signals not working yet, that's why  nothing gets displayed in a listview.

   Revision 1.20  1999/11/21 10:36:44  koss
   Settings are now read/written in class Settings.
   Renamed dock_widget -> kdock.
   Renamed drop_target -> kdrop.
   These two are not member variables anymore.
   In checkOnline() we use ConnectionDevices array.
   Now we are setting menubar & toolbar location according to settings.
   Added setAutoDisconnect().

   Revision 1.19  1999/11/19 19:03:41  koss
   Fixed remaining stuff for Settings class.
   Reading and writing of transfers moved to Transfer and TransferList.

   Revision 1.18  1999/11/18 21:37:10  koss
   Settings moved to class Settings.
   Removed slotApplySettings().
   Preferences dialog is now toggled like a Log window.
   Also it is not modal anymore => you can leave it opened and use Apply
   button.

   Revision 1.17  1999/11/17 19:13:44  koss
   Added QGuardPtr.
   defaultDirList is now QValueList.
   Finally fixed default directories feature.

   Revision 1.16  1999/11/16 18:28:20  koss
   Added slotApplySettings().
   Renamed all the rest of slots according to slotXXX() scheme.
   Added QWhatsThis stuff, at least toolbar buttons ( not working yet ).

   Revision 1.15  1999/11/15 20:31:16  koss
   Some member variables moved to Transfer as static.
   Removed Windows 9x style of docking ( we better make it consistent
   with all KDE apps through KDockWindow ).
   Reworked DockWidget and Droptarget classes.
   Introducing DlgSearch and setSearchData() / dataSearch().
   Added call to checkQueue() in readTransfers().

   Revision 1.14  1999/11/09 18:39:15  koss
   Ported to KMessageBox.
   Fixed auto-disconnect / timed-disconnect.
   Fixed slotPreferences().
   checkQueue() now gets called only when needed ( as in former versions ).

   Revision 1.13  1999/10/28 17:30:11  koss
   Removed some comments and code used for testing motif DND.

   Revision 1.12  1999/10/22 20:35:59  koss
   Fixed helpMenu() thingy.

   Revision 1.11  1999/10/18 22:05:28  koss
   switched from QStrList to QStringList.
   removed getIntFromString() and getStringFromInt().
   getBoolFromString() renamed to stringToBool().
   getStringFromBool() renamed to boolToString().

   Reworked philosophy:
       KItem renamed to Transfer, KMyListView to TransferList.
       Transfer now inherits QListViewItem.
       GlobalItemList removed, averything is now kept in TransferList.
       This means that we can move items around freely.
       Most of the slotXXX() methods moved to class Transfer.
       Methods xxxCurrent() moved to class Transfer.
       New logging - discerning general and per-transfer messages.

   Revision 1.10  1999/10/12 18:35:15  koss
   Transfer class moved to a separate file.
   Major rewrite because of porting to QListView :
        Now using new KMyListView class instead of KMyTabListBox.
        Multiple selections - toolbar works on multiple files.
   Fixed scheduling ( hopefuly ).
   Removed CORBA stuff.
   Fixed includes for Solaris ( for checkOnline() ) - need testing !
   Middle click is not used anymore:
        Now we use simple left mouse click to select / unselect.


   Revision 1.1.1.1  1998/05/06 19:13:31  matt
   Imported sources

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */


#ifndef _KMAINWIDGET_H_
#define _KMAINWIDGET_H_

#include <qguardedptr.h>

#include <ktmainwindow.h>

class KAction;
class KToggleAction;
class KRadioAction;

class DockWidget;
class DropTarget;
class LogWindow;
class DlgPreferences;

class Transfer;
class TransferList;
class Settings;


class KMainWidget : public KTMainWindow {

    Q_OBJECT

public:
  enum StatusbarFields { ID_TOTAL_TRANSFERS = 1, ID_TOTAL_FILES, ID_TOTAL_SIZE,
			 ID_TOTAL_TIME, ID_TOTAL_SPEED };

  KMainWidget();
  ~KMainWidget();

  void addTransfer( QString src, QString dest = QString::null );
  void addDropTransfers( QStrList *list );

  void setWindowStyle();
  void checkQueue();

  void setListFont();
  void setAutoSave();
  void setAutoDisconnect();

  LogWindow* logwin() { return logWindow; }

  friend class Settings;

  // Actions
  KToggleAction *m_paShowLog, *m_paPreferences;

public slots:
  void slotPasteTransfer();
  void slotToggleLogWindow();
  void slotTogglePreferences();

  void slotToggleExpertMode();
  void slotToggleOfflineMode();
  void slotToggleUseLastDir();
  void slotToggleAutoDisconnect();
  void slotToggleAutoShutdown();
  void slotToggleAutoPaste();

  void slotToggleAnimation();
  void slotToggleSound();

protected slots:
  void slotQuit();

  void slotOpenTransfer();
  void slotExportTransfers();
  void slotImportTransfers();
  void slotImportTextFile();

  void slotSaveYourself();
  void slotCheckConnection();
  void slotUpdateActions();

  void slotStatusChanged( Transfer *item, int _operation );

  void slotDock();
  void slotDropTarget();

  void slotResumeCurrent();
  void slotPauseCurrent();
  void slotDeleteCurrent();
  void slotRestartCurrent();

  void slotQueueCurrent();
  void slotTimerCurrent();
  void slotDelayCurrent();

  void slotOpenIndividual();

  void slotToggleStatusbar();

  void slotAnimTimeout();
  void slotTransferTimeout();
  void slotAutosaveTimeout();

  void slotMoveToBegin();
  void slotMoveToEnd();

  void slotCopyToClipboard();
  void slotCheckClipboard();

  void slotConfigureKeys();
  void slotConfigureToolbars();

  void slotPopupMenu( Transfer *item );

protected:
  void closeEvent( QCloseEvent * );

  void writeLog();

  // drag and drop
  void dragEnterEvent( QDragEnterEvent * );
  void dropEvent( QDropEvent * );

  void readTransfers( bool ask_for_name = false );
  void writeTransfers( bool ask_for_name = false );

  void setupTransferList();

  void setupGUI();
  void setupWhatsThis();

  void updateStatusBar();

  // some flags
  bool b_online;
  bool b_viewLogWindow;
  bool b_viewPreferences;

  // utility functions
  void disconnect();
  void checkOnline();
  void pauseAll();
  void log( const char *message, bool statusbar = true );

  // various timers
  QTimer *animTimer;         // animation timer
  QTimer *connectionTimer;   // timer that checks whether we are online
  QTimer *transferTimer;     // timer for scheduled transfers
  QTimer *autosaveTimer;     // timer for autosaving transfer list
  QTimer *clipboardTimer;    // timer for checking clipboard - autopaste function

  QString logFileName;

private:
  TransferList *myTransferList;
  KHelpMenu *menuHelp;

  LogWindow *logWindow;
  DlgPreferences* prefDlg;

  QString lastClipboard;

  QString currentDirectory;

  uint animCounter;

  int _sock;

  // Actions
  KAction *m_paOpenTransfer, *m_paPasteTransfer, *m_paExportTransfers, *m_paImportTransfers;
  KAction *m_paImportText, *m_paQuit;

  KAction *m_paMoveToBegin, *m_paMoveToEnd, *m_paCopy, *m_paIndividual;
  KAction *m_paResume, *m_paPause, *m_paDelete, *m_paRestart;
  KRadioAction *m_paQueue, *m_paTimer, *m_paDelay;

  KToggleAction *m_paUseAnimation, *m_paUseSound;
  KToggleAction *m_paExpertMode, *m_paUseLastDir, *m_paOfflineMode;
  KToggleAction *m_paAutoDisconnect, *m_paAutoShutdown, *m_paAutoPaste;

  KToggleAction *m_paShowStatusbar;
  KToggleAction *m_paDropTarget, *m_paDockWindow;
};

extern KMainWidget *kmain;
extern QGuardedPtr<DropTarget> kdrop;

#endif // _KMAINWIDGET_H_
