// $Id: tool.cpp,v 1.12 2000/06/05 11:04:59 hoelzer Exp $

#include <kdebug.h>
#include <stdio.h>
#include <assert.h>
#include <qpixmap.h>
#include "tool.h"

Tool::Tool()
{
  active= false;
  canvas= 0;
  props= 0;
  tooltip= 0;
}

Tool::Tool(const char *toolname)
  : name(toolname)
{
  active= false;
  canvas= 0;
  props= 0;
  tooltip= 0;
}


int Tool::getPages()
{
  return props;
}

void Tool::activate(Canvas *c)
{
  assert(!c->isActive());
  canvas= c;
  active= true;
  activating();
}

void Tool::deactivate()
{
  assert(active);
  deactivating();
  active= false;
  canvas= 0;
}

bool Tool::isActive()
{
  return active;
}

void Tool::setLeftPen(QPen &p)
{
  kdDebug(3000) << "Tool::setLeftPen()\n" << endl;
  leftpen= p;
}

void Tool::setLeftBrush(QBrush &b)
{
  kdDebug(3000) << "Tool::setLeftBrush()\n" << endl;
  leftbrush= b;
}

void Tool::setRightPen(QPen &p)
{
  kdDebug(3000) << "Tool::setRightPen()\n" << endl;
  rightpen= p;
}

void Tool::setRightBrush(QBrush &b)
{
  kdDebug(3000) << "Tool::setRightBrush()\n" << endl;
  rightbrush= b;
}

#include "tool.moc"
