/*
 * mainview.cpp. 
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#include "mainview.h"
#include "itemview.h"
#include "item.h"
#include "itemlist.h"
#include "catalog.h"
#include <qscrollview.h>
#include <qdir.h>
#include <kglobal.h>
#include <kiconloader.h>

#define TN_SIZE QSize(120,100)

MainView::MainView(QWidget *parent, const char *name)
 : QScrollView(parent, name), mCatalog(0)
{
   setResizePolicy(Manual);
   int h = 0;
   int w = 0;
   newX = 0;
   newY = 0;
   mRowSize = 3;
   mColCount = 0;
   mViewList = new ItemViewList();
   resizeContents(w,h);
   enableClipper(true);

   viewport()->setBackgroundPixmap(UserIcon("katalog_bg"));
   setMinimumSize(200,200);
}

MainView::~MainView()
{
   delete mViewList;
}

void 
MainView::resetCatalog()
{
   if (!mCatalog)
      return;
   disconnect(mCatalog, 0, this, 0);
   mCatalog = 0;
   mViewList->deleteAll();
   newX = 0;
   newY = 0; 
   resizeContents(0,0);
}

void 
MainView::setCatalog( Catalog *catalog) 
{ 
   resetCatalog(); 
   mCatalog = catalog; 
   connect(mCatalog, SIGNAL(destroyed()), this, SLOT(resetCatalog()));
   connect(mCatalog, SIGNAL(itemAdded(Item *)), this, SLOT(addItem(Item *)));
   connect(mCatalog, SIGNAL(itemRemoved(Item *)), this, SLOT(removeItem(Item *)));
   initItems();
}

void
MainView::initItems()
{
   // Add all items to the view
   for(Item *item = mCatalog->items()->first();
       item;
       item = mCatalog->items()->next())
   {
       ItemView *itemView = new ItemView(viewport(), item);   
       mViewList->append(itemView);
   }
   layoutItems();
}

void
MainView::updateView()
{
   setUpdatesEnabled(false);
   layoutItems();
   setUpdatesEnabled(true);
   repaint();
}

void 
MainView::layoutItems()
{
   mColCount = 0;
   mRowSize = 0; // mRowSize;
   newX = 0;
   newY = 0;

   int h = 0;
   int w = 0;

   for(ItemView *itemView = mViewList->first();
       itemView;
       itemView = mViewList->next())
   {
      if (mColCount == mRowSize)
      {   
         newY = h;
         newX = 0;
         mColCount = 0;
      }

printf("newX = %d, newY = %d\n", newX, newY);
      addChild(itemView, newX, newY);
      itemView->autoSize();
      itemView->show();
      h = QMAX(newY + itemView->height(), h);
      w = QMAX(newX + itemView->width(), w);
      if (mRowSize == 0)
      {
         mRowSize = 1;
         if (itemView->width())
         {
            mRowSize = visibleWidth() / itemView->width();
            if (!mRowSize)
               mRowSize = 1;
         }    
      }
      
      newX += itemView->width();
      mColCount++;
   }
printf("Width = %d, heigth = %d\n", w, h);
   resizeContents(w,h);
}

void
MainView::addItem(Item *newItem)
{
   if (mColCount == mRowSize)
   {
      newY = contentsHeight();
      newX = 0;
      mColCount = 0;
   }

   ItemView *itemView = new ItemView(viewport(), newItem);   
   mViewList->append(itemView);
printf("newX = %d, newY = %d\n", newX, newY);
   addChild(itemView, newX, newY);
   int h = QMAX(newY + itemView->height(), contentsHeight());
   int w = QMAX(newX + itemView->width(), contentsWidth());
    
   newX += itemView->width();
   mColCount++;

printf("Width = %d, heigth = %d\n", w, h);
   resizeContents(w,h);
   itemView->show();
}

void
MainView::removeItem(Item *oldItem)
{
   for(ItemView *itemView = mViewList->first();
       itemView;
       itemView = mViewList->next())
   {
       if (itemView->item() == oldItem)
       {
          mViewList->remove();
          delete itemView;
          break;
       }
   }
   // Update layout...
   layoutItems();
}


bool
MainView::addImage(const KURL &location, bool checkForDir)
{
printf("AddImage(%s, %s)\n",
	location.url().ascii(), checkForDir ? "true" : "false");
   if (!mCatalog)
   {
       setCatalog(new Catalog());
   }
   if (checkForDir && location.isLocalFile())
   {
      QString path = location.path(1); // Add trailing '/'
printf("Check for dir, path = %s\n", path.ascii());
      QDir localDir(path, QString::null, QDir::IgnoreCase, QDir::Files );
      if (localDir.exists())
      {
          bool result = false;
          QStringList dirList = localDir.entryList();
          for ( QStringList::Iterator it = dirList.begin(); 
                it != dirList.end(); 
                ++it )
          {
             KURL file(location);
             file.setPath(path+ (*it));
             if (addImage(file, false))
                result = true;
          }
          return result;
      }
   }

printf("addImage\n");
   Item *item = new Item(TN_SIZE);
   if (!item->loadImage(location))
   {
printf("Error loading image.\n");
      delete item;
      return false;
   }
printf("Loading OK.\n");
   mCatalog->addItem(item);
   return true;
}


bool
MainView::addImage(const QImage &img)
{
   if (!mCatalog)
   {
       setCatalog(new Catalog());
   }
printf("addImage\n");
   Item *item = new Item(TN_SIZE);
   if (!item->setImage(img))
   {
printf("Error setting image.\n");
      delete item;
      return false;
   }
printf("Loading OK.\n");
   mCatalog->addItem(item);
   return true;
}
