/*
 * catalog.h 
 *
 * Copyright (C) 1999 Waldo Bastian
 *
 */

#ifndef _CATALOG_H_
#define _CATALOG_H_

#include <qobject.h>
#include <qstring.h>
#include <qsize.h>

class ItemList;
class Item;

class Catalog : public QObject
{
   Q_OBJECT
   
   QString mLocation;
   QString mAddImageDir;
   ItemList *mItemList;

   QSize mTnSize;
   bool bViewName;
   bool bViewSize;
   bool bViewFilesize;
   bool bViewDesc;
public:
   Catalog();
   ~Catalog();
   
   bool load( const QString &filename );
   bool save();
   bool saveAs( QString &filename);
   
   bool dirty() { return mDirty; }
   bool empty() { return mNew && !mDirty; }
   
   QString filename() { return mLocation; }

   QString addImageDir() { return mAddImageDir; }
   void addImageDir(const QString addImageDir) { mAddImageDir = addImageDir; }

   QSize tnSize() { return mTnSize; }
   void setTnSize(QSize tnSize) { mTnSize = tnSize; }

   bool viewName() { return bViewName; }
   void viewName(bool _viewName) { bViewName = _viewName; }

   bool viewSize() { return bViewSize; }
   void viewSize(bool _viewSize) { bViewSize = _viewSize; }

   bool viewFilesize() { return bViewFilesize; }
   void viewFilesize(bool _viewFilesize) { bViewFilesize = _viewFilesize; }

   bool viewDesc() { return bViewDesc; }
   void viewDesc(bool _viewDesc) { bViewDesc = _viewDesc; }

   ItemList *items() { return mItemList; }

public slots: 
   void addItem(Item *);
   void removeItem(Item *);

signals:
   void itemAdded(Item *);
   void itemRemoved(Item *);

protected:
   bool mDirty;
   bool mNew;
};

#endif
