/*
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   

#include <config.h>
#include <stdio.h>
#include <unistd.h>

// QT includes
#include <qdir.h>

// KDE includes
#include <kglobal.h>
#include <kstddirs.h>
#include <kiconloader.h>
#include <kapp.h>

// own includes
#include "kpaint.h"
#include "defines.h"

extern CardImages  *cardImage;


CardWidget::CardWidget( QWidget *parent, const char *name )
  : QPushButton( parent, name )
{
  held = false;
  move(1,1);
  resize(cardWidth, cardHeight);
  setBackgroundMode( NoBackground ); // disables flickering
  connect(this, SIGNAL(clicked()), this, SLOT(ownClick()));
}

void CardWidget::paintCard(int cardType)
{
  if (cardType==0)
    pm=&cardImage->deck;
  else
    pm=&cardImage->cardP[cardType-1];
  if ( pm->size() != QSize( 0, 0 ) ) {   // is an image loaded?
  	setPixmap(*pm);
  }
}

void CardWidget::ownClick()
{
  emit pClicked(this);
}

bool CardWidget::queryHeld()
{
  return held;
}

void CardWidget::setHeld(bool newheld)
{
  held = newheld;
}

bool CardWidget::toggleHeld()
{
  held = !held;
  return held;
}

bool CardImages::loadCards()
{
 int w;
 int randomDeck;

 QString fname;
 for (w = 0; w < highestCard; w++) {
 	fname = KGlobal::dirs()->findResource("appdata", QString("pics/%1.png").arg(w+1));

 	if(!cardP[w].load(fname)) {
 		warning(QString("Fatal error: bitmap %1 not found - try reading from current dir").arg(QString("pics/%1.png").arg(w+1)));
 		QDir dir;
		dir.cd("pics");

 		if(!cardP[w].load(dir.absPath()+QString("/%1.png").arg(w+1))) {
	 		warning(QString("Fatal error: bitmap %1/pics/%2.png not found").arg(dir.absPath()).arg(w+1));
		
		} else {
	 		warning(QString("Found bitmap in %1/%2.png").arg(dir.absPath()).arg(w+1));
		}
	}
 }

 randomDeck = (kapp->random() % 4) +1;

 fname = KGlobal::dirs()->findResource("appdata", QString("pics/deck%1.png").arg(randomDeck));
 if(!deck.load(fname)) {
 	warning(QString("Fatal error: bitmap %1 not found - try reading from current dir").arg(QString("pics/deck%1.png").arg(randomDeck)));
 	QDir dir;
	dir.cd("pics");
	if (!deck.load(dir.absPath() + QString("/deck%1.png").arg(randomDeck))) {
	 	warning(QString("Fatal error: bitmap %1/deck%2.png not found").arg(dir.absPath()).arg(randomDeck));

	} else 
 		warning(QString("Found bitmap in %1/deck%2.png").arg(dir.absPath()).arg(randomDeck));
 }
 return 1;

}

CardImages::CardImages(QWidget* parent, const char* name) : QWidget(parent, name)
{
 cardP = new QPixmap[highestCard];
 hide();
 loadCards();
}

CardImages::~CardImages()
{
delete[] cardP;
}
