/*  This file is part of the KDE XmlRpc package

    Copyright (C) 1999 Kurt Granroth (granroth@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef KXMLRPCDAEMON_H
#define KXMLRPCDAEMON_H

#include <kxmlrpcserver.h>
#include <dcopobject.h>

class DCOPClient;
class KXmlRpcProxy;

/**
 * This class implements the KDE XmlRpc Daemon.  It is an XmlRpc
 * server running at a known port. It "translates" incoming XmlRpc
 * requests into DCOP requests and forwards them to the specified DCOP
 * client.  It then, as a DCOP client, will accept the return value
 * from the DCOP client and "translate" it back to XmlRpc.
 *
 * The advantage of this approach is that neither the XmlRpc client
 * nor the DCOP client/server need to know that they are "talking" the
 * other protocol.
 *
 * @short KDE XmlRpc Daemon
 * @author Kurt Granroth <granroth@kde.org>
 * @version 0.1
 */
class KXmlRpcDaemon : public KXmlRpcServer
{
public:
    /**
     * Standard constructor.  This will attach and register a DCOP
     * client.  It will register as 'xmlrpcd'.  If registration fails
     * for some reason, then the daemon will exit immediately.
     */
    KXmlRpcDaemon();

    /**
     * Standard destructor.  This detaches the client
     */
    virtual ~KXmlRpcDaemon();

protected:
    /**
     * Implementation of the virtual function 'dispatch'.  This
     * function is responsible for doing the actual DCOP call.  It
     * will also get the return value if there is one.
     */
    virtual void dispatch(const QString& _name, const QString& _object,
                          const QString& _proto, const QByteArray& _param,
                          const QString& _auth);

    /**
     * Implementation of needAuth().
     */
    virtual bool needAuth() const;

private:
    void processTrader(const QString& _proto, const QByteArray& _params);
    void processReturnValue(const QString& _type, const QByteArray& _reply);

private:
    DCOPClient   *m_dcopClient;
    QString       m_authToken;
    KXmlRpcProxy *m_proxy;
};

class KXmlRpcProxy : public DCOPObjectProxy
{
public:
    KXmlRpcProxy(DCOPClient *_client);

    virtual bool process(const QCString& obj, const QCString& fun,
                         const QByteArray& data, QCString& replyType,
                         QByteArray &replyData);

};
#endif // KXMLRPCDAEMON_H
