/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

/*
    The pidfile portions of this code have been shamelessly stolen from kdehelp.
    These parts are (c) 1997 Martin Jones
*/

#include <qvariant.h>

#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <sys/stat.h>
#include <time.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <kuniqueapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kwm.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstddirs.h>
#include "OldView.h"
#include "ksv_core.h"
#include "kndraglist.h"
#include <qpopupmenu.h>
#include "TopWidget.h"

// copyright notice
#include "version.h"

static const char* copyright = "KSysV " KSYSV_VERSION_STRING "  Copyright 1997-2000 Peter Putzer.";
static const char* license = "All rights reserved. Released under the GNU General Public License (GPL).";




// // segfault handler
// static void segHandler( int sig )
// {
//   printf("Caught SIGSEGV %i, exiting...\n", sig );
//   printf("Please mail a bug-report to putzer@kde.org\n");

//   abort();
// }

// make sure the pid file is cleaned up when exiting unexpectedly.

// void catchSignals() {
//   //      signal(SIGHUP, cleanup);                /* Hangup */
//   signal(SIGINT, cleanup);                /* Interrupt */
//   signal(SIGTERM, cleanup);               /* Terminate */
//   //      signal(SIGCHLD, cleanup);

// //   signal(SIGABRT, cleanup);
//   signal(SIGALRM, cleanup);
//   signal(SIGFPE, cleanup);
//   signal(SIGILL, cleanup);
//   signal(SIGPIPE, cleanup);
//   signal(SIGQUIT, cleanup);
//   signal(SIGSEGV, segHandler); // we should exit cleanly at least

// #ifdef SIGBUS
//   signal(SIGBUS, cleanup);
// #endif
// #ifdef SIGPOLL
//   signal(SIGPOLL, cleanup);
// #endif
// #ifdef SIGSYS
//   signal(SIGSYS, cleanup);
// #endif
// #ifdef SIGTRAP
//   signal(SIGTRAP, cleanup);
// #endif
// #ifdef SIGVTALRM
//   signal(SIGVTALRM, cleanup);
// #endif
// #ifdef SIGXCPU
//   signal(SIGXCPU, cleanup);
// #endif
// #ifdef SIGXFSZ
//   signal(SIGXFSZ, cleanup);
// #endif
// }



void myMessageOutput( QtMsgType type, const char *msg )
{
  switch ( type ) {
#if (defined(DEBUG) && !(defined(NDEBUG) || defined(NO_DEBUG)))
#warning Building a debug version - do not distribute!
  case QtDebugMsg:
    fprintf( stderr, "Debug: %s\n", msg );
    break;
  case QtWarningMsg:
    fprintf( stderr, "Warning: %s\n", msg );
    break;
#endif
  case QtFatalMsg:
    fprintf( stderr, "Fatal: %s\n", msg );
    abort(); // dump core on purpose
  }	
}

int main( int argc, char **argv ) {
  // install own message handler that ignores debug-msg when DEBUG is not defined
  qInstallMsgHandler(myMessageOutput);

  fprintf(stderr, "%s\n", copyright);
  fprintf(stderr, "%s\n", license);

  KAboutData about("ksysv", I18N_NOOP("SysV-Init Editor"), KSYSV_VERSION_STRING,
		   I18N_NOOP("An editor for Sys-V like init configurations."),
		   KAboutData::License_GPL,
		   "Copyright  1997-2000, Peter Putzer.",
		   "test",
		   "http://eclipt.uni-klu.ac.at/projects/ksysv");
  about.addAuthor ("Peter Putzer", I18N_NOOP("Main developer"), "putzer@kde.org");
  KSVCore::setAbout (&about);

  KCmdLineArgs::init(argc, argv, &about);

#if (!defined(DEBUG) || (defined(NDEBUG) || defined(NO_DEBUG)))
  KUniqueApplication::addCmdLineOptions ();

  if (!KUniqueApplication::start()) {
	fprintf(stderr, i18n("KSysV is already running!\n"));
	// FIXME
  }

  KUniqueApplication app;
#else // debug version
  KApplication::addCmdLineOptions ();
  KApplication app;
#endif // !defined(DEBUG) || (defined(NDEBUG) || defined(NO_DEBUG))

  // to signal errors to scripts... well its cleaner at least
  int returnValue = 1;

#if (defined(DEBUG) && !(defined(NDEBUG) || defined(NO_DEBUG)))
#warning Disabling check for root...
  if (true)
#else
  if (geteuid() == 0)
#endif
    {
 
      // session-management
      if (kapp->isRestored())
    	  RESTORE(KSVTopLevel)
      else
        {
          KSVTopLevel* top = new KSVTopLevel();
		  //           kapp->setMainWidget( top ); // done in KSVTopLevel ctor
          top->show();
        }
      // end session-management

    	returnValue = app.exec();
    }
  else
    {
      QWidget* dummy = new QWidget();
      dummy->setIcon(kapp->miniIcon());
      dummy->resize (1,1);
      dummy->move (kapp->desktop()->width()/2, kapp->desktop()->height()/2);
      KWM::setDecoration (dummy->winId(), KWM::noDecoration|KWM::noFocus);
      dummy->show();

    	KMessageBox::error( dummy, 
							i18n("Only root is allowed to manage runlevels."),
							kapp->makeStdCaption(i18n("Error")) );
    	returnValue = 1;
    	
    	delete dummy;
    }

  return -returnValue;
}
