/***************************************************************************
                          OldView.h  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_VIEW_H
#define KSV_VIEW_H

#include <qwidget.h>

#include "Constants.h"

class QPopupMenu;
class QFileInfo;
class QLabel;
class QListViewItem;
class QTextView;
class QFrame;
class QScrollView;
class QVBox;
class QPixmap;
class QLayout;

class KProcess;
class KListView;
class QSplitter;
class KPopupMenu;
class KSVTrash;
class KSVDragList;
class KSVConfig;
class KSVData;
class KSVItem;
class KSVAction;
class KSVTopLevel;

class KSVContent : public QWidget
{
  Q_OBJECT

public:
  KSVContent(KSVTopLevel* parent = 0, const char* name = 0);
  ~KSVContent();
  
  KSVDragList* getOrigin();

  QString log() const;
//   {
// 	return textDisplay->text();
//   }

//   inline int logLines() const
//   {
//     return textDisplay->numLines();
//   }

//   inline QString logLine (int line) const
//   {
//     return textDisplay->textLine(line);
//   }

  /**
   * Returns true if the widget is initializing the runlevels
   */
  inline bool isInitializing() const { return mClearing; }

  void setNewNormalColor (const QColor&);
  void setChangedNormalColor (const QColor&);

  void repaintRunlevels (bool);

public slots:
  void slotWriteSysV();
  void reInit();
  void infoOnData(KSVItem* data);
  void setDisplayScriptOutput(bool val);
  void slotScriptProperties (QListViewItem*);
  void multiplexEnabled (bool);

  void hideRunlevel (int index);
  void showRunlevel (int index);

protected:
  virtual void resizeEvent (QResizeEvent* e);
  virtual void moveEvent (QMoveEvent* e);
  virtual bool eventFilter (QObject* o, QEvent* e);

private slots:
  void slotChanged();
  void startService();
  void startService (const QString& path);
  void stopService();
  void stopService (const QString& path);
  void restartService();
  void restartService (const QString& path);
  void editService();
  void editService (const QString& path);
  void slotOutput( KProcess* _p, char* _buffer, int _buflen );
  void slotErr( KProcess* _p, char* _buffer, int _buflen );
  void slotExitedProcess(KProcess* proc);
  void slotToggleOut();
  void slotScriptsNotRemovable();
  void slotDoubleClick (QListViewItem*);
  void slotExitDuringRestart(KProcess* proc);
  void appendLog(const QString& txt);
  void fwdCannotGenerateNumber();
  void fwdSelected (int, QListViewItem*, const QPoint&, int);
  void fwdSelectedScripts (int, QListViewItem*, const QPoint&, int);
  void reSortRL();
  void pasteAppend();
  void fwdUndoAction(KSVAction*);
  void fwdEmpty (QListViewItem*);
  void updatePanningFactor();

  void popupRunlevelMenu (KListView*, QListViewItem*, const QPoint&);
  void popupServicesMenu (KListView*, QListViewItem*, const QPoint&);

signals:
  void sigChanged();
  void sigUpdateParent();
  void sigRun (const QString&);
  void sigStop();
  void sigNotRemovable();
  void progress(int val);
  void advance(int steps);
  void initProgress (int max, const QString& label);
  void endProgress();
  void cannotGenerateNumber();
  void selected (KSVItem*);
  void selectedScripts (KSVItem*);
  void sizeChanged();
 
  void undoAction (KSVAction*);
  void logChanged();

private:
  static int splitterToPanningFactor (const QValueList<int>&);
  static const QValueList<int>& panningFactorToSplitter (int);

  void doPannerResize (int oldPan);

  void initLList();
  void initLayout();
  void initScripts();
  void initRunlevels();
  void info2Widget (QFileInfo* info, int index);
  void writeToDisk (const KSVData& _w, int _rl, bool _start);
  void clearRL( int _rl );

  friend class KSVTopLevel;
  QSplitter* panner;
  QFrame* mContent;
  QScrollView* scroller;

  KSVDragList* startRL[RUNLEVEL_NR];
  KSVDragList* stopRL[RUNLEVEL_NR];
  KSVDragList* scripts;

  KPopupMenu* mItemMenu;
  KPopupMenu* mContextMenu;
  KPopupMenu* mScriptMenu;
  KSVTrash* trash;
  QTextView* textDisplay;
  KSVConfig* conf;
  bool mClearing;

  QVBox* mScriptBox;
  QVBox* mRunlevels[RUNLEVEL_NR];
  QWidget* mBuffer;

};

#endif
