/***************************************************************************
                          About.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#pragma implementation

#include <qlabel.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qvbox.h>

#include <kurllabel.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kaboutdata.h>
#include <kglobalsettings.h>
#include <kdebug.h>
#include <klocale.h>

#include "About.h"
#include "ksv_core.h"

// some constants
#include "version.h"

#define MIN_SIZE(A) A->setMinimumSize(A->sizeHint())

AboutDlg::AboutDlg (QWidget* parent)
  : KDialogBase (parent, "AboutDialog", false, i18n("About %1").arg(kapp->aboutData()->programName()),
				 Help|Close, Close, false)
{
  QWidget* page = new QWidget (this);
  setMainWidget (page);
  
  QBoxLayout* topLayout = new QVBoxLayout(page, 0, spacingHint());

  QFont normal_bold_font = KGlobalSettings::generalFont();
  normal_bold_font.setBold(true);

  QFont large_bold_font = normal_bold_font;
  large_bold_font.setPointSize( large_bold_font.pointSize() * 2 );

  QFont small_bold_font = normal_bold_font;
  small_bold_font.setPointSize( small_bold_font.pointSize() - 2 );

  QLabel* title = new QLabel (kapp->aboutData()->programName(), page);
  title->setFont(large_bold_font);
  title->setAlignment(AlignCenter);
  MIN_SIZE(title);
  topLayout->addWidget(title);

  QBoxLayout* picLayout = new QHBoxLayout(0);
  topLayout->addLayout(picLayout);
  QLabel* pic = new QLabel(page);
  pic->setPixmap(DesktopIcon("ksysv", 48));
  MIN_SIZE(pic);
  picLayout->addWidget(pic);
  picLayout->addSpacing(KDialog::spacingHint());

  QBoxLayout* versionLayout = new QVBoxLayout(0);
  picLayout->addLayout(versionLayout);
  picLayout->addStretch (1);
  versionLayout->addStretch(KDialog::spacingHint());

  QLabel* version = new QLabel (i18n("Version %1").arg(KSYSV_VERSION_STRING), page);
  version->setFont(normal_bold_font);
  MIN_SIZE(version);
  versionLayout->addWidget(version);

  QBoxLayout* copyLayout = new QHBoxLayout(0);
  versionLayout->addLayout(copyLayout);

  QLabel* copyright1 = new QLabel( i18n("%1 1997-2000 ").arg(KSVCore::copyrightSymbol()), page);
  copyright1->setFont(normal_bold_font);
  copyright1->setAlignment ( AlignLeft | WordBreak );
  MIN_SIZE(copyright1);
  copyLayout->addWidget(copyright1);

  QBoxLayout* authorLayout = new QVBoxLayout(0);
  copyLayout->addLayout(authorLayout);
  authorLayout->addSpacing(1);
  KURLLabel* copyright2 = new KURLLabel(page, "CopyrightLabel");
  copyright2->setText("Peter Putzer");
  copyright2->setURL("mailto:putzer@kde.org");
  copyright2->setFloat(true);
  copyright2->setUnderline(false);
  copyright2->setTipText(i18n("Mail bug report/success story/lots of money/..."));
  copyright2->setUseTips(TRUE);
  copyright2->setFont(normal_bold_font);
  copyright2->setAlignment( AlignLeft | WordBreak );

  // react on click
  connect(copyright2, SIGNAL(leftClickedURL(const QString&)), this, SLOT(callURL(const QString&)));

  // insert into layout
  MIN_SIZE(copyright2);
  authorLayout->addWidget(copyright2);

  QLabel* copyright3 = new QLabel( i18n(". All rights reserved."), page);
  copyright3->setFont(normal_bold_font);
  copyright3->setAlignment( AlignLeft | WordBreak );
  MIN_SIZE(copyright3);
  copyLayout->addWidget(copyright3);

  QLabel* additionalCopyright =
    new QLabel (i18n(/* "IPC parts taken from kdehelp (C) 1997 Martin Jones.\n" \ */
					 "Printing taken from kedit %1 1997 Bernd Johannes Wuebben.\n" \
					 "Uses the KDE %2 libraries %3 1997-2000 The KDE Team.\n" \
					 "Uses the Qt %4 library %5 1992-2000 Troll Tech AS.")
				.arg(KSVCore::copyrightSymbol())
				.arg(KDE_VERSION_STRING).arg(KSVCore::copyrightSymbol())
				.arg(QT_VERSION_STR).arg(KSVCore::copyrightSymbol()), page);

  additionalCopyright->setFont(small_bold_font);
  MIN_SIZE(additionalCopyright);
  topLayout->addWidget(additionalCopyright);




  QLabel* description
    = new QLabel( i18n("An editor for SysV-style init configuration, similar "\
				 "to Red Hat's \"tksysv\", only ksysv allows drag-and-drop, "\
				 "as well as keyboard use."), page );

  description->setAlignment( AlignLeft | WordBreak );
  description->setMargin(KDialog::spacingHint());
  description->setFrameStyle( QFrame::Box | QFrame::Sunken );
  description->setMinimumWidth(kapp->desktop()->width() / 3);
  description->setMinimumHeight (description->heightForWidth(description->width()));
  topLayout->addWidget(description, KDialog::spacingHint());

  QLabel* license
    = new QLabel(i18n("This program is free software; you can redistribute it and/or modify it under the " \
				" terms of version 2 of the GNU General Public License as published by the Free " \
				"Software Foundation." \
				"\n\n" \
				"This program is distributed in the hope that it will be useful, but WITHOUT ANY " \
				"WARRANTY; without even the implied warranty of MERCHANTABILITY or " \
				"FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License " \
				"for more details."), page);

  license->setAlignment( AlignLeft | WordBreak );
  license->setFont(small_bold_font);
  license->setFrameStyle(QFrame::Box | QFrame::Sunken);
  license->setMargin(KDialog::spacingHint());
  license->setMinimumWidth(kapp->desktop()->width() / 3);
  license->setMinimumHeight (license->heightForWidth(license->width()));

  topLayout->addWidget(license, KDialog::spacingHint());
  topLayout->addSpacing(KDialog::spacingHint());


  setFixedSize (minimumSize());
}

AboutDlg::~AboutDlg()
{
  // nothing
}

void AboutDlg::callURL (const QString& url)
{
  kapp->invokeMailer (url, "KSysV");
}

AboutDlg* AboutDlg::self ()
{
  static AboutDlg* dlg = new AboutDlg (kapp->mainWidget());

  return dlg;
}
