/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __PCIDEVICE_H
#define __PCIDEVICE_H

#include "device.h"
#include "xserver.h"


class PCIDevice : public Device
{
  public:
  
    enum pciclass     { PCIClassUnclassifiedNonVGA    = 0x0000,
    			PCIClassUnclassifiedVGA	      = 0x0001,
			
    			PCIClassStorageSCSI 	      = 0x0100,
                        PCIClassStorageIDE	      = 0x0101,
                        PCIClassStorageFloppy         = 0x0102,
                        PCIClassStorageIPI	      = 0x0103,
                        PCIClassStorageRAID	      = 0x0104,
                        PCIClassStorageOther          = 0x0180,

                        PCIClassNetworkEthernet	      = 0x0200,
                        PCIClassNetworkTokenring      = 0x0201,
                        PCIClassNetworkFDDI	      = 0x0202,
                        PCIClassNetworkATM	      = 0x0203,
                        PCIClassNetworkOther	      = 0x0280,

                        PCIClassDisplayVGA	      = 0x0300,
                        PCIClassDisplayXGA	      = 0x0301,
                        PCIClassDisplayOther          = 0x0380,

                        PCIClassMultimediaVideo	      = 0x0400,
                        PCIClassMultimediaAudio	      = 0x0401,
                        PCIClassMultimediaOther	      = 0x0480,

                        PCIClassMemoryRAM             = 0x0500,
                        PCIClassMemoryFlash	      = 0x0501,
                        PCIClassMemoryOther	      = 0x0580,

                        PCIClassBridgeHost	      = 0x0600,
                        PCIClassBridgeISA	      = 0x0601,
                        PCIClassBridgeEISA	      = 0x0602,
                        PCIClassBridgeMC	      = 0x0603,
                        PCIClassBridgePCI	      = 0x0604,
                        PCIClassBridgePCMCIA          = 0x0605,
                        PCIClassBridgeNuBus	      = 0x0606,
                        PCIClassBridgeCardBus         = 0x0607,
                        PCIClassBridgeOther	      = 0x0680,

                        PCIClassCommunicationSerial   = 0x0700,
                        PCIClassCommunicationParallel = 0x0701,
                        PCIClassCommunicationOther    = 0x0780,

                        PCIClassSystemPIC	      = 0x0800,
                        PCIClassSystemDMA	      = 0x0801,
                        PCIClassSystemTimer	      = 0x0802,
                        PCIClassSystemRTC	      = 0x0803,
                        PCIClassSystemOther	      = 0x0880,

                        PCIClassInputKeyboard         = 0x0900,
                        PCIClassInputPen	      = 0x0901,
                        PCIClassInputMouse	      = 0x0902,
                        PCIClassInputOther	      = 0x0980,

                        PCIClassDockingGeneric        = 0x0a00,
                        PCIClassDockingOther	      = 0x0a01,

                        PCIClassProcessor386	      = 0x0b00,
                        PCIClassProcessor486	      = 0x0b01,
                        PCIClassProcessorPentium      = 0x0b02,
                        PCIClassProcessorAlpha	      = 0x0b10,
                        PCIClassProcessorPowerPC      = 0x0b20,
                        PCIClassProcessorCo	      = 0x0b40,

                        PCIClassSerialFirewire        = 0x0c00,
                        PCIClassSerialACCESS          = 0x0c01,
                        PCIClassSerialSSA	      = 0x0c02,
                        PCIClassSerialUSB	      = 0x0c03,
                        PCIClassSerialFiber	      = 0x0c04 };
  
    PCIDevice(uint bus, uint slot, uint func, uint vendorid, uint deviceid,
              baseclass, pciclass);
    
    ~PCIDevice() {}
    
    virtual bustype   busType() 	     const { return BusPCI;	}
    
    virtual QString   deviceClassName();
    virtual QString   deviceName();
    virtual devstate  deviceState();
    virtual QString   vendorName();
    
    virtual Driver    *deviceDriver();
    
  private:
  
    QString   _vendorname;
    QString   _devicename;
  
    uint      _bus, _slot, _func;
    uint      _vendorid, _deviceid;
    pciclass  _pciclass;
    devstate  _devicestate;
    
    void     lookupData();
    XServer  *serverInfo();
};


#endif
