//////////////////////////////////////////////////////////////
//      $Id: pkgInterface.h,v 1.9 2000/01/07 15:36:41 toivo Exp $ 
//
// Author: Toivo Pedaste
//

#ifndef PKG_IFACE_H
#define PKG_IFACE_H

#include "../config.h"
#include <qlist.h>
#include <qstring.h>
#include <qstringlist.h>

#include "packageInfo.h"
#include "procbuf.h"

class packageInfo;
class installationWidget;
class  pkginstallDialogMult;
class pkguninstallDialog;
class pkguninstallDialogMult;
class Locations;
class LcacheObj;
class cacheObj;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
typedef struct param {
  const char *name;
  bool init;
  bool invert;
} param;
// Structure for flags to install and uninstall
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class pkgInterface: public QObject 
{
  Q_OBJECT
 
public:
  pkgInterface();
  virtual ~pkgInterface();
  
  virtual bool isType(char *buf, const QString &fname) =  0;
  // looks at start of file to check that package is correct type

  virtual param *initinstallOptions() = 0;
  virtual param *inituninstallOptions() =  0;
  // return appropriate param blocks

  virtual packageInfo *getPackageInfo(char mode, const QString &name, const QString &version) =  0;
  // get info on installed or uninstalled package. version is only set if
  // mode is 'i' (ie, if the package is already installed).

  virtual QStringList *getFileList(packageInfo *p) =  0;
  // get list of files in the package

  virtual QStringList *depends(const QString &name, int src);
  // check dependencies for package

  virtual QStringList *verify(packageInfo *p, const QStringList &files);
  // check the installed files in a package

  virtual int uninstall(int uninstallFlags, QList<packageInfo> *p);
  virtual int uninstall(int uninstallFlags, packageInfo *p);
  // uninstall package or packages

  virtual int install(int installFlags, QList<packageInfo> *p);
  virtual int install(int installFlags, packageInfo *p);
  // install package or packages

  virtual int doUninstall(int installFlags, QString packs);
  virtual int doInstall(int installFlags, QString packs);

  virtual QString FindFile(const QString &name) = 0;
  // search for packages containg a file

  virtual bool parseName(QString name, QString *n, QString *v) = 0;
  // breakup file name into package name and version

  virtual void listPackages(QList<packageInfo> *pki);
  // scan various locations for list of packages

  virtual void listInstalledPackages(QList<packageInfo> *pki) = 0;
  // produce list of currently installed packages

  virtual void smerge(packageInfo *p);
  // merge in package info entry

  QString getDir(cacheObj *cp);
  // list directory local or remote

  void listDir(QList<packageInfo> *pki, QString fname, QString dir);
  // list the packages in a directory

  packageInfo *collectDir(QString name, QString size, QString dir);
  // build packageInfo object from directory entry

  QString getPackList(cacheObj *cp);
  // get packages information file

  virtual QString  provMap(QString p);
  // convert from package depends to package

  ///////////// DATA ///////////////////////
  installationWidget *installation;
  pkginstallDialogMult *installationMult;
  pkguninstallDialog *uninstallation;
  pkguninstallDialogMult *uninstallationMult;
  // install and uninstall widgets for this package type

  QString icon;
  // name icon file
  QString head;
  // capitalized name of package type
  QPixmap pict, bad_pict, new_pict, updated_pict;
  // icons for package states
  QPixmap folder;
  // icon for package group
  QPixmap markInst;
  QPixmap markUnInst;
  // icon indicating mark for install/uninstall

  Locations *locatedialog;
  // dialog for setting the locations of  uninstalled packages
  LcacheObj *packageLoc;
  // List of locations of uninstalled pacckages
  
  QString tmpDir;
  bool dirOK;
  // variables related to reading packages from directories

  QString packagePattern;
  QString queryMsg;
  QString typeID;
  // Parameters for reading packages from directories

  procbuf reader;
  QString procMsg;
  // for running processes

public slots:
  virtual void setLocation() = 0;
  virtual void setAvail(LcacheObj *) = 0;
};

#endif





