#ifndef _ICONVIEW_
#define _ICONVIEW_

#include <qtableview.h>
#include <qpixmap.h>

class IconElement {

public:

  IconElement() { name="<unassigned>"; pixmap=0; }
  ~IconElement() { delete pixmap; }
  QString name;
  QPixmap * pixmap;

};

class IconView : public QTableView {

  int xsize,ysize;
  QArray<IconElement *> elements;
  void zero();

public:

  IconView(QWidget * parent=0,const char * name=0,WFlags f=0);
  ~IconView() {}
  virtual void paintCell(QPainter *,int,int);
  virtual void mousePressEvent(QMouseEvent *);
  void load_files(QString);
  void load_file(QString,int);
  void updateSize() { updateTableSize(); }

  void save(QString);
  void load_index(QString);
  void do_new();

protected:

  virtual int cellWidth(int);

  virtual void dragEnterEvent(QDragEnterEvent *);
  virtual void dropEvent(QDropEvent *);

};

#endif
