/**************************************************
 *
 **************************************************
 * This code was created by Peter Harvey @ CodeByDesign.
 * Released under LGPL 28.JAN.99
 *
 * Contributions from...
 * -----------------------------------------------
 * Peter Harvey		- pharvey@codebydesign.com
 **************************************************/
#include <odbcinstext.h>

typedef struct tODBCINSTErrorMsg
{
	int 	nCode;
	char	*szMsg;
} ODBCINSTErrorMsg;

static ODBCINSTErrorMsg aODBCINSTErrorMsgs[] =
{
	ODBC_ERROR_GENERAL_ERR,					"ODBC_ERROR_GENERAL_ERR",
	ODBC_ERROR_INVALID_BUFF_LEN,			"ODBC_ERROR_INVALID_BUFF_LEN",
	ODBC_ERROR_INVALID_HWND,				"ODBC_ERROR_INVALID_HWND",
	ODBC_ERROR_INVALID_STR,					"ODBC_ERROR_INVALID_STR",
	ODBC_ERROR_INVALID_REQUEST_TYPE,		"ODBC_ERROR_INVALID_REQUEST_TYPE",
	ODBC_ERROR_COMPONENT_NOT_FOUND,			"ODBC_ERROR_COMPONENT_NOT_FOUND",
	ODBC_ERROR_INVALID_NAME,				"ODBC_ERROR_INVALID_NAME",
	ODBC_ERROR_INVALID_KEYWORD_VALUE,		"ODBC_ERROR_INVALID_KEYWORD_VALUE",
	ODBC_ERROR_INVALID_DSN,					"ODBC_ERROR_INVALID_DSN",
	ODBC_ERROR_INVALID_INF,					"ODBC_ERROR_INVALID_INF",
	ODBC_ERROR_REQUEST_FAILED,				"ODBC_ERROR_REQUEST_FAILED",
	ODBC_ERROR_INVALID_PATH,				"ODBC_ERROR_INVALID_PATH",
	ODBC_ERROR_LOAD_LIB_FAILED,				"ODBC_ERROR_LOAD_LIB_FAILED",
	ODBC_ERROR_INVALID_PARAM_SEQUENCE,		"ODBC_ERROR_INVALID_PARAM_SEQUENCE",
	ODBC_ERROR_INVALID_LOG_FILE,			"ODBC_ERROR_INVALID_LOG_FILE",
	ODBC_ERROR_USER_CANCELED,				"ODBC_ERROR_USER_CANCELED",
	ODBC_ERROR_USAGE_UPDATE_FAILED,			"ODBC_ERROR_USAGE_UPDATE_FAILED",
	ODBC_ERROR_CREATE_DSN_FAILED,			"ODBC_ERROR_CREATE_DSN_FAILED",
	ODBC_ERROR_WRITING_SYSINFO_FAILED,		"ODBC_ERROR_WRITING_SYSINFO_FAILED",
	ODBC_ERROR_REMOVE_DSN_FAILED,			"ODBC_ERROR_REMOVE_DSN_FAILED",
	ODBC_ERROR_OUT_OF_MEM,					"ODBC_ERROR_OUT_OF_MEM",
	ODBC_ERROR_OUTPUT_STRING_TRUNCATED,		"ODBC_ERROR_OUTPUT_STRING_TRUNCATED"
};


/* THIS WILL HOLD OUR LOG MESSAGES. ITS INIT IN _init() AND MEMORY IS FREED IN _fini() */
HLOG hODBCINSTLog;

RETCODE SQLInstallerError(		WORD	nError,
								DWORD	*pnErrorCode,
								LPSTR	pszErrorMsg,
								WORD	nErrorMsgMax,
								WORD	*pnErrorMsg )
{
	char szMsgHdr[LOG_MSG_MAX+1];
	char szMsg[LOG_MSG_MAX+1];

	if ( nError != 1 || pnErrorCode == NULL || pszErrorMsg == NULL )
		return SQL_NO_DATA;

    pszErrorMsg[0] = '\0';

	if ( inst_logPopMsg( szMsgHdr, (int *)pnErrorCode, szMsg ) != LOG_SUCCESS )
		return SQL_NO_DATA;

	sprintf( pszErrorMsg, "%s\n%s\n%s", szMsgHdr, (aODBCINSTErrorMsgs[*pnErrorCode]).szMsg, szMsg );

	if ( pnErrorMsg != NULL )
		*pnErrorMsg = strlen( pszErrorMsg );
	
	return SQL_SUCCESS;
}


