#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <qdir.h>

#include <pws.h>
#include <klocale.h>
#include <pws.moc>

PWS::PWS(QWidget *, const char *name)
	: KTMainWindow(name)
{
    createdUI = FALSE;
    menuBar = 0x0;
    statusBar = 0x0;
    toolBar = 0x0;
    view = 0x0;
}

PWS::~PWS()
{
    if(view != 0)
        delete view;
}

void PWS::invokeHelp()
{
	kapp->invokeHTMLHelp("pws/pws.html", "");
}

void PWS::show(){
    if(createdUI == FALSE){
        QPopupMenu *file_menu = new("QPopupMenu") QPopupMenu();
        file_menu->insertItem(i18n("E&xit"), kapp, SLOT(quit()));

        QPopupMenu *help_menu = new("QPopupMenu") QPopupMenu();
        help_menu->insertItem(i18n("&Help"), this, SLOT(invokeHelp()));

        //	menuBar = new("KMenuBar") KMenuBar(this, "menubar");
        //	menuBar->insertItem(i18n("&File"), file_menu);
        //	menuBar->insertItem(i18n("&Help"), help_menu);

        //	setMenu(menuBar);

        //	toolBar = new("KToolBar") KToolBar(this);
        //	addToolBar(toolBar);

        //	statusBar = new("KStatusBar") KStatusBar(this);
        //	setStatusBar(statusBar);

        //        resize(600,440);
        view = new("PWSWidget") PWSWidget(this);
        setView(view);

        connect(view, SIGNAL(quitPressed(QObject *)),
                this, SLOT(closeView(QObject *)));

        createdUI = TRUE;
    }
    KTMainWindow::show();
}

void PWS::closeView(QObject *obj){
  emit quitPressed(obj);
  /*
   obj = 0x0;
   delete view;
   view = 0x0;
   createdUI = FALSE;
   */
}
