#ifndef ADDWIZARD_H
#define ADDWIZARD_H

#include <kwizard.h>

class QWidget;
class QLineEdit;
class KIntNumInput;
class ServerNamePage;
class PublicDirPage;
class PortPage;
class EndPage;

class AddServerWizard: public KWizard
{
    Q_OBJECT
public:
    AddServerWizard();
    virtual ~AddServerWizard();
    QStrList data;
public slots:
    void forward();
    void finished();
private:
    ServerNamePage *wp;
    PublicDirPage *pdp;
    PortPage *pp;
    EndPage *ep;
};

class ServerNamePage: public QWidget
{
    Q_OBJECT
public:
    ServerNamePage(QWidget *parent);
    virtual ~ServerNamePage();
    bool validate();
    QLineEdit *name;
    QString data();
};

class PublicDirPage: public QWidget
{
    Q_OBJECT
public:
    PublicDirPage(QWidget *parent);
    virtual ~PublicDirPage();
    bool validate();
    QLineEdit *name;
    QString data();
public slots:
    void setDirName();
};

class PortPage: public QWidget
{
    Q_OBJECT
public:
    PortPage(QWidget *parent);
    virtual ~PortPage();
    bool validate();
    KIntNumInput *port;
    QString data();
};

class EndPage: public QWidget
{
    Q_OBJECT
public:
    EndPage(QWidget *parent);
    virtual ~EndPage();
};

#endif
