/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_ 


#include <ktmainwindow.h>
#include <qmainwindow.h>


class QLineEdit;
class QPushButton;
class KButtonBox;
class QMultiLineEdit;
class KProcess;


class TopLevel : public QMainWindow
{
    Q_OBJECT

public:
    TopLevel();
    ~TopLevel();

protected slots:
    void slotSearch();
    void slotCancel();
    void childExited();
    void receivedOutput(KProcess *proc, char *buffer, int buflen);
    
private:
    void finish();

    QLineEdit *wordsedit;
    QPushButton *searchbutton, *cancelbutton;
    QMultiLineEdit *resultbox;
    KProcess *childproc;
};
 
#endif 


// Local Variables:
// c-basic-offset: 4
// End:
