/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <stdio.h>

#include <qbrush.h>
#include <qpainter.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kurl.h>
#include <klocale.h>
#include <kstddirs.h>

#include "resultview.h"


ResultViewItem::ResultViewItem( QListView *parent, QString icon, QString name, QString url,
				int relevance, QString details )
    : QListViewItem(parent, name, "-", "")
{
    m_relevance = relevance;
    m_url = url;
    m_details = details;

    if (!icon.isEmpty())
	setPixmap(0, locate( "data", "columbo/pics/" + icon ) );
    // Consider relocations;
    int pos;
    if ( (pos = url.findRev("http://")) > 0) {
	url.remove(0, pos-1);
    }
    KURL kurl(url);
    setText(SiteColumn, kurl.host());
}


QString ResultViewItem::key(int col, bool ascending) const {
    static char strbuf[5];
    if (col == RelevanceColumn) {
	return sprintf(strbuf, "%02d",
		       (m_relevance==-1)? 999 : 100-m_relevance), strbuf;
    } else {
	return QListViewItem::key(col, ascending);
    }
}


QString ResultViewItem::text(int col) const {
    static char strbuf[5];
    if (col == RelevanceColumn && m_relevance != -1)
	return sprintf(strbuf, "%02d", m_relevance), strbuf;
    else
	return QListViewItem::text(col);
}       


void ResultViewItem::paintCell(QPainter *p, const QColorGroup &cg,
			       int col, int width, int align) {
    if (col == RelevanceColumn && m_relevance != -1) {
	int w = width * m_relevance / 100;
	int h = height();
	QBrush fill( cg.mid() );
	p->fillRect(0, 0, width, h, cg.base());
	qDrawShadePanel(p, 0, 0, w, h, cg, false, 2, &fill);
    } else {
	QListViewItem::paintCell(p, cg, col, width, align);
    }
}


ResultView::ResultView(QWidget *parent, const char *name)
    : QListView(parent, name) {
    QFontMetrics fm( fontMetrics() );
    int nameColumnWidth = fm.width(i18n("let's take a fairly long name string for this"));
    int relevanceColumnWidth =  fm.width(i18n("Relevance")) + 15;
    addColumn( i18n("Name"), nameColumnWidth );
    addColumn( i18n("Relevance"), relevanceColumnWidth );
    addColumn( i18n("Site") );
    //	       sizeHint().width()-nameColumnWidth-relevanceColumnWidth );
    setSorting(ResultViewItem::RelevanceColumn);


    connect( this, SIGNAL(doubleClicked(QListViewItem*)),
	     SLOT(itemActivated(QListViewItem*)) );
    connect( this, SIGNAL(selectionChanged(QListViewItem*)),
	     SLOT(itemSelected(QListViewItem*)) );
}


void ResultView::insertItem(QString icon, QString name, QString url,
			    int relevance, QString details) {
    (void) new ResultViewItem(this, icon, name, url,
			      relevance, details);
}


void ResultView::itemActivated(QListViewItem *item) {
    emit urlActivated(static_cast<ResultViewItem*>(item)->m_url);
}


void ResultView::itemSelected(QListViewItem *item) {
    emit detailsActivated(static_cast<ResultViewItem*>(item)->m_details);
}
