// $Id: dlgSearch.cpp,v 1.3 2000/03/19 17:53:55 koss Exp $

#include <qlayout.h>

#include <klocale.h>
#include <kdialog.h>

#include "settings.h"
#include "dlgSearch.h"


DlgSearch::DlgSearch( QWidget *parent )
  : QGroupBox( parent ) {

  setTitle(i18n("Search Options"));

  QGridLayout *searchLayout = new QGridLayout( this, 4, 4, 20, KDialog::spacingHint() );

  searchLayout->setRowStretch(0,5);
  searchLayout->setRowStretch(1,5);
  searchLayout->setRowStretch(2,5);
  searchLayout->setRowStretch(3,5);
    
  searchLayout->setColStretch(0,2);
  searchLayout->setColStretch(1,5);
  searchLayout->setColStretch(2,5);
  searchLayout->setColStretch(3,5);

  // use search ?
  cb_search = new QCheckBox( i18n("Search fastest server"), this );
  searchLayout->addMultiCellWidget( cb_search, 0, 0, 0, 21);

  // search items
  lb_maxnum = new QLabel( i18n("Maximum number of search entries :"), this );
  searchLayout->addMultiCellWidget( lb_maxnum, 1, 1, 1, 2 );

  le_maxnum = new KIntNumInput( 0, this, 10 );
  searchLayout->addWidget( le_maxnum, 1, 3 );

  // search timeout
  lb_timeout = new QLabel( i18n("Search timeout :"), this );
  searchLayout->addWidget( lb_timeout, 2, 1 );

  le_timeout = new KIntNumInput( 0, this, 10 );
  le_timeout->setSuffix( i18n("seconds") );
  searchLayout->addWidget( le_timeout, 2, 2 );

  // switch hosts ?
  cb_switch = new QCheckBox( i18n("Switch hosts automatically"), this );
  searchLayout->addMultiCellWidget( cb_switch, 3, 3, 1, 2 );

  connect( cb_search, SIGNAL(toggled(bool)), le_maxnum, SLOT(setEnabled(bool)) );
  connect( cb_search, SIGNAL(toggled(bool)), le_timeout, SLOT(setEnabled(bool)) );
  connect( cb_search, SIGNAL(toggled(bool)), cb_switch, SLOT(setEnabled(bool)) );
}


void DlgSearch::setData() {
  cb_search->setChecked( ksettings.b_searchFastest );
  le_maxnum->setEnabled( ksettings.b_searchFastest );
  le_timeout->setEnabled( ksettings.b_searchFastest );
  cb_switch->setEnabled( ksettings.b_searchFastest );

  le_maxnum->setValue( ksettings.searchItems );
  le_timeout->setValue( ksettings.timeoutSearch );
  cb_switch->setChecked( ksettings.b_switchHosts );
}


void DlgSearch::applyData() {
  ksettings.b_searchFastest = cb_search->isChecked();
  ksettings.searchItems = le_maxnum->value();
  ksettings.timeoutSearch = le_timeout->value();
  ksettings.b_switchHosts = cb_switch->isChecked();
}

