/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <ksimpleconfig.h>
#include <kglobal.h>
#include <kstddirs.h>

#include "pluginmgr.h"
#include "global.h"

InternalApplet* KickerPluginManager::loadPlugin(const QString &applnk, QWidget *parent)
{
  static bool dlregistered = false;
  QString libStr, applnkPathStr;
  
  applnkPathStr = KGlobal::dirs()->findResource("internalapplets", applnk);
  
  KSimpleConfig config(applnkPathStr);
  config.setDesktopGroup();
  libStr = config.readEntry("X-KDE-Library", "");
  libStr += ".la";
  libStr = KGlobal::dirs()->findResource("lib", libStr);
  if(!libStr){
    warning("Kicker: cannot find kicker internal applet");
    return(NULL);
  }
  
  if(!dlregistered){
    dlregistered = true;
    lt_dlinit();
  }
  
  lt_dlhandle handle = lt_dlopen(libStr.latin1());
  if(!handle){
    warning("Kicker: cannot open kicker internal applet: %s because of %s",
            libStr.latin1(), lt_dlerror());
    return(NULL);
  }
  
  lt_ptr_t init_func = lt_dlsym(handle, "init");
  if(!init_func){
    warning("Kicker: %s is not a kicker internal applet!",
            libStr.latin1());
    lt_dlclose(handle);
    return(NULL);
  }
  
  InternalApplet* (*init_ptr)(QWidget *, KWinModule *);
  init_ptr = (InternalApplet* (*)(QWidget *, KWinModule *))init_func;
  InternalApplet *w = init_ptr(parent, PGlobal::kwin_module);
  lt_dlhandle *tmp = new lt_dlhandle;
  *tmp = handle;
  handleDict.insert((long)w, tmp);
  return(w);
}

bool KickerPluginManager::removePlugin(QWidget *w)
{
  lt_dlhandle *handle = handleDict.find((long)w);
  if(!handle){
    warning("Kicker: Cannot find handle to remove internal applet!");
    return(false);
  }
  handleDict.remove((long)w);
  delete w;
  if(!lt_dlclose(*handle)){
    warning("Kicker: Unable to unload internal applet!");
    return(false);
  }
  return(true);
}




        
