#include "minibutton.h"
#include <qpainter.h>

KMiniPagerButton::KMiniPagerButton(int desk, QWidget *parent, const char *name)
  : QButton(parent, name)
{
  deskStr = deskStr.number(desk);
  deskNum = desk;
  connect(this, SIGNAL(clicked()), SLOT(slotClicked()));
}

void KMiniPagerButton::paintEvent(QPaintEvent *)
{
  QPainter p(this);
  p.setFont(font());
  
  if(!isOn() && !isDown())
  {
    p.fillRect(rect(), colorGroup().brush(QColorGroup::Dark));
    p.setPen(colorGroup().light());
    p.drawLine(0, 0, width()-1, 0);
    p.drawLine(0, 0, 0, height()-1);
    p.setPen(Qt::black);
    p.drawLine(0, height()-1, width()-1, height()-1);
    p.drawLine(width()-1, 0, width()-1, height()-1);
    p.setPen(Qt::white);
  }
  else
  {
    p.fillRect(rect(), colorGroup().brush(QColorGroup::Base));
    p.setPen(colorGroup().text());
    p.drawRect(rect());
  }
  p.drawText(0, 0, width(), height(), AlignCenter, deskStr);
}

void KMiniPagerButton::slotClicked()
{
  emit deskChangeRequest(deskNum);
}

void KMiniPagerButton::mousePressEvent(QMouseEvent *ev)
{
  if (ev->button()==RightButton) emit showPopupMenu(0,mapToGlobal(ev->pos()));

  QButton::mousePressEvent(ev);
} 
