/*
 *  MoniKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef DXWIN_H
#define DXWIN_H

#include <qtabbar.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qtabdialog.h>
#include <qlineedit.h>
#include <qlistbox.h>

#include <ktablistbox.h>



class DXWinTbl : public KTabListBox
{
   Q_OBJECT;
public:
   DXWinTbl( QWidget *parent );
protected:
   void mousePressEvent( QMouseEvent *e );
signals:
   void showKontextMenu();
};


typedef struct _s_dxdata
{
   struct _s_dxdata *next;

   char *dx_call;
   char *absender;
   float qrg;
   int zeit;
   char *bemerkung;
} s_dxdata;


typedef struct _s_dxviews
{
   struct _s_dxviews *next;

   double lowerqrg;
   double upperqrg;
   char *label;
   int tabid;
   DXWinTbl *tbl;

   s_dxdata *dataroot;
   int datacount;
   int currentitem;
} s_dxviews;



class DXWin : public QWidget
{
   Q_OBJECT;

public:
   DXWin( QWidget *parent, QWidget *tl );
   void resizeEvent(QResizeEvent *e);

   s_dxviews * addDXView(char *label, double lowerqrg, double upperqrg);
   void delDXView( const char  *label );
   void addDXMessage(char *dx_call, char *absender, float qrg, int zeit, char *bemerkung);
   void resizeTabBar();
   s_dxviews * getViewsRoot();

public slots:
   void changeTab(int id);
   void slotShowKontextMenu(int, int);
   void slotShowKontextMenu();
   void slotSaveViewList();
   void slotSelectLine(int index, int);

private:
   QTabBar *tabbar;
   QPopupMenu *kontextmenu;

   s_dxviews *dxviewroot;
   s_dxviews *aktview;
   int akttab;

   void loadViewsList();

protected:
   void mousePressEvent( QMouseEvent *e );
};



class DlgAddView : public QTabDialog
{
   Q_OBJECT;
public:
   DlgAddView();
   ~DlgAddView();

   void getData( double & min, double & max, char *desc );

public slots:
   void saveData();

private:
   void setupWindowQRG();
   void setupWindowGeneral();
   void readData();

   QLineEdit *minQRG, *maxQRG, *name;
   double lowerqrg;
   double upperqrg;


   QWidget *winQRG, *winGeneral;
};


class DlgDelView : public QDialog
{
   Q_OBJECT;
public:
   DlgDelView( s_dxviews *views );
   ~DlgDelView();

   const char * getListName();

public slots:
   void slotOkClicked();

private:
   s_dxviews *dxviews;

   QListBox *liste;
   QPushButton *ok, *abort;
};


#endif
