/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef YAPP_H
#define YAPP_H


#include <qwidget.h>
#include <qtimer.h>

#include "dialog.h"

class YAPP : public QObject
{
   Q_OBJECT;
public:
   YAPP( QWidget *rxchan );
   ~YAPP();

   void saveFile( char *data, int len );
   bool isSendYapp( char *data, int len );
   bool isRxfile();
   bool getNextPacket( char *data, int & length );
   int getState();
   void abortTransfer();

   bool proceed( char *data, int len );
   int sendYAPP( char *filename );
   int receiveYAPP( char *filename=NULL );

public slots:
   void sendBlock();

private:
   void sendData( char *data, int len );

   void SendRR();
   void SendRF();
   void SendRT();
   void SendAF();
   void SendAT();
   void SendSI();
   void SendHD();
   void SendDT( int length );
   void SendEF();
   void SendET();
   void SendNR( char *reason );
   void SendRE( int length );
   void SendCN( char *reason );
   void SendRS(int length);
   void SendData();
   bool readHeader( char *data, int & len );
   bool readData( char *data, int & len );
   void unknownCode();
   bool lookForAbort( char *data );
   bool lookForStart( char *tmp, int & len );

   unsigned char checksum( char *data, int len );
   void openTransferWin( bool tx );
   void sendTransferInfo( bool tx );

   QTimer *timer;
   QWidget *chan;
   bool rxFile;
   char *filename;
   char *shortname;
   long filelen;
   long total;
   bool yappc;
   int fd;
   int file_time;
   time_t starttime;
   char *savedata;
   int savelen;

   int state;

   TransferWin *win;
   TransferInfo *transInfo;
   bool extraTransferWin;
   int wascomp;				// 0 = keine kompression, 1 = //COMP, 2 = #HUF#
};



#endif

