/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "router.h"
#include "toolbox.h"
#include "global.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>



//   Router::Router()
//
// Alle Routen lokal eintragen
Router::Router()
{
/*   majornode = (s_routenode *) malloc(sizeof(s_routenode));
   majornode->same = NULL;
   majornode->leaf = NULL;
   majornode->call = (char *) strdup("\0");
   majornode->parent = NULL;*/
   majornode = NULL;
}


Router::~Router()
{
}


//   void Route::addRoute(char *call, char *path)
//
// Traegt die Route zu einem bestimmten Rufzeichen (und allen Calls
// dazwischen) ein.
void Router::addRoute(char *call, char *path)
{
   char *tmp, *str;
   int i,len;
   s_routenode *tmpnode, *newnode,*lastnode;


   // Wenn das Call schon existiert, wird die Route geaendert.


   // Es ist ein Pfad dabei. Call fuer Call des Pfades durchwandern und
   // erstmal eine Route zu jedem Call des Pfades eintragen
   str = (char *) strdup(path);
   tmp = (char *) strdup(path);

   tmpnode = majornode;
   lastnode = majornode;

   while (str[0] != '\0')
   {
      if ((i = POS(' ', str)) == -1)
      {
         // Das letzte Call
         strcpy(tmp, str);
         str[0] = '\0';
      }
      else
      {
         memcpy(tmp, str, i);
         tmp[i] = '\0';
         len = strlen(str)-i-1;
         memmove(str, str+i+1, len);
         str[len] = '\0';
      }

      if ((newnode = getCallInLeaf(tmp, tmpnode)) == NULL)
         newnode = addCallToLeaf(tmp, lastnode);

      if (majornode == NULL)
         majornode = newnode;

      lastnode = newnode;
      tmpnode = newnode->leaf;
   }

   // Jetzt kommt noch der Pfad zum eigentlichen Zielrufzeichen
   if (getCallInLeaf(call, tmpnode) == NULL)
      addCallToLeaf(call, lastnode);

   free(tmp);
   free(str);
}


//   void Route::showRoutes()
//
// Zeigt eine Liste aller eingetragener Routen an.
void Router::showRoutes()
{
   s_routenode *samenode;
   char output[100];

   if (majornode == NULL)
   {
      printf("No routes!\n");
      return;
   }

   output[0] = '\0';
   samenode = majornode;

   while (samenode != NULL)
   {
      printf("%s\n", samenode->call);
      showThisNode(samenode->leaf, 1);

      samenode = samenode->same;
   }
}


//   void Route::showThisNode(s_routenode *node)
//
// Zeigt alle Rufzeichen an, die unter diesem Node eingetragen sind. Fuer
// jede weitere Ebene wird die Funktion rekursiv nochmal aufgerufen.
void Router::showThisNode(s_routenode *node, int ebene)
{
   s_routenode *samenode;
   char spaces[] = "                                                                                      ";

   spaces[ebene*5] = '\0';
   ebene++;

   samenode = node;
   while (samenode != NULL)
   {
      // Dieses Rufzeichen ausgeben
      printf("%s%s\n", spaces, samenode->call);
      showThisNode(samenode->leaf, ebene);

      samenode = samenode->same;
   }
}


//   s_routenode * Route::getCallInLeaf(char *call, s_routenode *node)
//
// Guckt, das uebergebene Rufzeichen in der in "node" uebergebenen
// Ebene existiert. Wenn ja wird ein Pointer auf die entsprechende
// Struktur zurueck gegeben, sonst NULL.
//
// Damit diese Abfrage was bringt, sollte der uebergebene Node natuerlich
// der erste Node einer Ebene sein!
s_routenode * Router::getCallInLeaf(char *call, s_routenode *node)
{
    s_routenode *tmpnode;


    tmpnode = node;
    while (tmpnode != NULL)
    {
       if (!strcmp(tmpnode->call, call))
          return tmpnode;
       tmpnode = tmpnode->same;
    }
    return NULL;
}


//   s_routenode * Router::addCallToLeaf(char *call, s_routenode *last)
//
// Traegt die Route zu einem bestimmten Rufzeichen auf der Ebene des
// uebergebenen Nodes ein.
// Rueckgabe: Ein Pointer auf den gerade neu eingetragenen Knoten.
s_routenode * Router::addCallToLeaf(char *call, s_routenode *last)
{
   s_routenode *tmpnode;

   // Wenn dies das allererste Call ist, wird es erstellt.
   if (last == NULL)
      tmpnode = (s_routenode *) malloc(sizeof(s_routenode));
   else
   {
      if (last->leaf == NULL)
      {
         tmpnode = (s_routenode *) malloc(sizeof(s_routenode));
         last->leaf = tmpnode;
      }
      else
      {
         tmpnode = last->leaf;
         while (tmpnode->same != NULL) tmpnode = tmpnode->same;
         tmpnode->same = (s_routenode *) malloc(sizeof(s_routenode));
         tmpnode = tmpnode->same;
      }
   }
   tmpnode->same = NULL;
   tmpnode->leaf = NULL;
   tmpnode->call = (char *) strdup(call);
   tmpnode->parent = last;
   return tmpnode;
}


//   s_routenode * Router::getCallPtr()
//
// Gibt den Pointer auf den Eintrag des uebergebenen Rufzeichens zurueck.
// Wenn das Call nicht gefunden wird, wird NULL zurueck gegeben.
s_routenode * Router::getCallPtr( char *call )
{
   s_routenode *samenode,*rueck;

   if (majornode == NULL)
      return NULL;

   samenode = majornode;

   while (samenode != NULL)
   {
      if ((rueck = getCallPtrNode(samenode->leaf, call)) != NULL) return rueck;

      samenode = samenode->same;
   }

   return NULL;
}



//   s_routenode Router::getCallPtrNode(s_routenode *node, char *call)
//
// Guckt, ob in dieser Ebene das gesuchte Rufzeichen vorhanden ist.
// Wenn ja wird ein Pointer auf die Adresse zurueckgegeben, sonst NULL.
s_routenode * Router::getCallPtrNode(s_routenode *node, char *call)
{
   s_routenode *samenode,*rueck=NULL;

   samenode = node;
   while (samenode != NULL)
   {
      // Dieses Rufzeichen ausgeben
      if (!strcmp(call, samenode->call)) return samenode;
      if ((rueck = getCallPtrNode(samenode->leaf, call)) != NULL) return rueck;

      samenode = samenode->same;
   }

   return NULL;
}


//   void Router::getPath( char *call, bool & changed )
//
// Gibt den Pfad zu dem uebergebenen Rufzeichen in der Variable call zurueck
// (oder das Rufzeichen selbst, wenn kein Pfad bekannt ist).
void Router::getPath( char *call, bool & changed )
{
   s_routenode *node;
   char tmp[5000], tmp2[5000], firstcall[100], port[100];

   changed = false;

   tmp[0] = '\0';
   firstcall[0] = '\0';
   port[0] = '\0';

   if ((node = getCallPtr( call )) == NULL) return;

   while (node != NULL)
   {
      if (firstcall[0] == '\0')
         // Erstes Rufzeichen = Call der Gegenstation
         strcpy(firstcall, node->call);
      else
      {
         if (node->parent == NULL)
            strcpy(port, node->call);
         else
         {
            sprintf(tmp2,"%s %s", node->call, tmp);
            strcpy(tmp, tmp2);
         }
      }

      node = node->parent;
   }

   sprintf(tmp2,"%s %s %s", port, firstcall, tmp);
   strcpy(tmp, tmp2);

   strcpy(call, tmp);
   changed = true;
}


//   s_routenode * getMajorNode()
//
// Gibt den Pointer auf den Root-Knoten zurueck.
s_routenode * Router::getMajorNode()
{
   return majornode;
}


//   void Router::saveRoutes()
//
// Speichert alle Routen in einem File ab.
void Router::saveRoutes()
{
   char tmp[500], port[500], path[500];
   s_routenode *node;
   int fd;


   sprintf(tmp,"%s/router.dat", config->maindir);

   if ((fd = open(tmp,O_WRONLY|O_CREAT|O_TRUNC)) == -1)
      return;

   // Zugriffsrechte einstellen
   fchmod(fd,S_IRUSR|S_IWUSR);

   node = majornode;
   path[0] = '\0';

   while (node != NULL)
   {
      strcpy(port, node->call);
      saveRoutesShowNode(node->leaf, path, port, fd);

      node = node->same;
   }

   close(fd);
}


//   void Router::saveRoutesShowNode(s_routenode *node, char *path, char *port, int fd)
void Router::saveRoutesShowNode(s_routenode *node, char *path, char *port, int fd)
{
   s_routenode *samenode;
   char lpath[500],tmp[500];

   samenode = node;
   while (samenode != NULL)
   {
      sprintf(tmp,"%s %s %s\n", samenode->call, port, path);
      write(fd, tmp, strlen(tmp));
      if (path[0] == '\0')
         strcpy(lpath, samenode->call);
      else
         sprintf(lpath, "%s %s", path, samenode->call);
      saveRoutesShowNode(samenode->leaf, lpath, port, fd);

      samenode = samenode->same;
   }
}


//   void Router::readRoutes()
//
// Alle Routen aus dem File router.dat einlesen
void Router::readRoutes()
{
   char tmp[500], call[100];
   FILE *f;
   int i,len;


   sprintf(tmp,"%s/router.dat", config->maindir);

   if ((f = fopen(tmp, "r")) == NULL) return;

   while (fgets(tmp, 499, f) != NULL)
   {
      if ((i = POS('\r', tmp)) > -1) tmp[i] = '\0';
      if ((i = POS('\n', tmp)) > -1) tmp[i] = '\0';

      if ((i = POS(' ', tmp)) > -1)
      {
         memcpy(call, tmp, i);
         call[i] = '\0';
         len = strlen(tmp)-i-1;
         memmove(tmp, tmp+i+1, len);
         tmp[len] = '\0';

         addRoute(call, tmp);
      }
   }

   fclose(f);
}


//   void Router::deleteNode( char *call )
//
// Loescht den uebergebenen Knoten und alle Routen, die von diesem
// Knoten abhaengen.
void Router::deleteNode( char *call )
{
   s_routenode *node;

   node = getCallPtr( call );

   deleteInParentNode(node);
   deleteThisNode( node->leaf );
   free(node);
}


//   void Router::deleteInParentNode(s_routenode *node)
//
// Der uebergebene Node wird im Parentnode gesucht und der entsprechende
// Verweis dort auf NULL gesetzt.
void Router::deleteInParentNode(s_routenode *node)
{
   s_routenode *leaf, *last;

   leaf = node->parent->leaf;

   last = NULL;
   while (leaf != NULL)
   {
      if (leaf == node)
      {
         if (last == NULL)
            node->parent->leaf = leaf->same;
         else
            last->same = leaf->same;
      }
      last = leaf;
      leaf = leaf->same;
   }
}


//   void Router::deleteThisNode(s_routenode *node)
//
// Rekursive Funktion - loescht den uebergebenen Node und alle Leafnodes,
// gibt also deren Speicher frei.
void Router::deleteThisNode(s_routenode *node)
{
   s_routenode *samenode,*save;

   samenode = node;
   while (samenode != NULL)
   {
      save = samenode;
      deleteThisNode(samenode->leaf);
      samenode = samenode->same;
      free(save);
   }
}
