/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "passwords.h"
#include "channel.h"
#include "toolbox.h"
#include <kapp.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>


const char AtoZ[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char atoz[] = "abcdefghijklmnopqrstuvwxyz";
const char zahlen[] = "01234567890";


Passwords::Passwords(QWidget *rxchan)
{
   chan = rxchan;
   mode = 0;
   dbtime = NULL;

   uinfo = ((Channel *)chan)->userinfo;
}


Passwords::~Passwords()
{
}


void Passwords::proceed( const char *data, int len )
{
   switch (mode)
   {
      case 0: if (((Channel *)chan)->userinfo->getPwmode() == PW_DIEBOX_OLD)
                 checkDieBoxPrompt( data, len );
              break;
      case 1: checkForPwline( data, len ); break;
   }
}


//   void Passwords::transmit()
// Eine Passwort-Anfrage wurde gestellt.
void Passwords::transmit()
{
   char *cmd;
   char tmp[100];

   cmd = ((Channel *)chan)->userinfo->getPwCommand();
   if (cmd == NULL)
   {
      KMsgBox::message(NULL, klocale->translate("Failure"),
                             klocale->translate("You have to configure the password-command."));
      return;
   }

   if (cmd[0] == '\0')
   {
      KMsgBox::message(NULL, klocale->translate("Failure"),
                             klocale->translate("You have to configure the password-command."));
      return;
   }


   if (((Channel *)chan)->userinfo->getPwmode() == 0)
   {
      KMsgBox::message(NULL, klocale->translate("Failure"),
                             klocale->translate("You have to configure the password-type."));
      return;
   }

   if (((Channel *)chan)->userinfo->getPwd() == NULL)
   {
      KMsgBox::message(NULL, klocale->translate("Failure"),
                             klocale->translate("You have to configure the password."));
      return;
   }

   if ((((Channel *)chan)->userinfo->getPwmode() == PW_FLEXNET_OLD) ||
       (((Channel *)chan)->userinfo->getPwmode() == PW_AK1A))
      ((Channel *)chan)->flags &= ~CH_LINEMODE;

   if (((Channel *)chan)->userinfo->getPwmode() == PW_DIEBOX_OLD)
      sendTheboxOldPw();
   else
   {
      sprintf(tmp, "%s\r", cmd);
      ((Channel *)chan)->sendString( tmp );
      mode = 1;
      line = 0;
   }
}


void Passwords::checkForPwline( const char *data, int len )
{
   switch (((Channel *)chan)->userinfo->getPwmode())
   {
      case PW_BAYBOX:
           checkPromptBaybox( data, len );
           break;
      case PW_FLEXNET_OLD:
           checkPromptFlexOld( data, len );
           break;
      case PW_MD5:
           checkPromptMD5( data, len );
           break;
      case PW_AK1A:
           checkPromptAK1A( data, len );
           break;
   }

   line++;
   if (line > 20)
      mode = 0;
}


void Passwords::checkPromptBaybox( const char *data, int len )
{
   char str[2000], tmp[1000], tmp2[1000], *pw;
   int i,k,zahl,pos;
   char answerstr[6];
   char random[200];


   if ((i = POS('>', data)) == -1) return;

   memcpy(str, data, len);
   str[len] = '\0';

   // FBBs schicken   CALL>  1 2 3 4 5 [abcdefghijklm]
   // [....] entfernen wenn vorhanden
   i = POS('[', str);
   k = POS(']', str);
   if (i != -1 && k != -1 && i < k)
   {
      str[i] = '\0';
      KillSpacesRight(str);
   }

   while ((i = POS('>', str)) != -1)
   {
      len = strlen(str)-i-1;
      memmove(str, str+i+1, len);
      str[len] = '\0';
   }

   KillSpacesRight( str );
   KillSpacesLeft( str );
   len = strlen(str);

   pw = ((Channel *)chan)->userinfo->getPwd();
   if (pw == NULL)
   {
      mode = 0;
      return;
   }

   i = 0;
   while (i<5)
   {
      if ((k = POS(' ', str)) == -1)
      {
         if (len == '\0') return;
         strcpy(tmp, str);
         len = 0;
         str[0] = '\0';
      }
      else
      {
         memcpy(tmp, str, k);
         tmp[k] = '\0';
         len = strlen(str)-k-1;
         memmove(str, str+k+1, len);
         str[len] = '\0';
      }

      zahl = atoi(tmp);
      answerstr[i] = pw[zahl-1];

      i++;
   }
   answerstr[i] = '\0';

   if (((Channel *)chan)->userinfo->getPwAnswer() == 0)
   {
      // Passwort aussenden
      sprintf(tmp,"%s\r", answerstr);
      ((Channel *)chan)->sendString( tmp );
   }
   else
   {
      // Passwort im String verstecken
      generateRandomChars( random, ((Channel *)chan)->userinfo->getPwAnswerLen()-5 );

      pos = (int) ((((Channel *)chan)->userinfo->getPwAnswerLen()-5.0)*rand()/(RAND_MAX+1.0));

      memcpy(tmp, random, pos);
      tmp[pos] = '\0';
      memcpy(tmp2, random+pos, strlen(random)-pos);
      tmp2[strlen(random)-pos] = '\0';

      // Passwort aussenden
      sprintf(str,"%s%s%s\r", tmp, answerstr, tmp2);
      ((Channel *)chan)->sendString( str );
   }

   mode = 0;
}


void Passwords::checkPromptAK1A( const char *data, int len )
{
   char str[200],tmp[200],tmp2[200],*pw;
   int i,k,zahl,pos;
   char answerstr[6];
   char random[200];


   if ((i = POS('>', data)) == -1) return;

   memcpy(str, data, len);
   str[len] = '\0';
   while ((i = POS('>', str)) != -1)
   {
      len = strlen(str)-i-1;
      memmove(str, str+i+1, len);
      str[len] = '\0';
   }

   KillSpacesRight( str );
   KillSpacesLeft( str );
   len = strlen(str);

   pw = ((Channel *)chan)->userinfo->getPwd();
   if (pw == NULL)
   {
      mode = 0;
      return;
   }

   i = 0;
   while (i<4)
   {
      if ((k = POS(' ', str)) == -1)
      {
         if (len == '\0') return;
         strcpy(tmp, str);
         len = 0;
         str[0] = '\0';
      }
      else
      {
         memcpy(tmp, str, k);
         tmp[k] = '\0';
         len = strlen(str)-k-1;
         memmove(str, str+k+1, len);
         str[len] = '\0';
      }

      zahl = atoi(tmp);
      answerstr[i] = pw[zahl-1];

      i++;
   }
   answerstr[i] = '\0';

   if (((Channel *)chan)->userinfo->getPwAnswer() == 0)
   {
      // Passwort aussenden
      sprintf(tmp,"%s\r", answerstr);
      ((Channel *)chan)->sendString( tmp );
   }
   else
   {
      // Passwort im String verstecken
      generateRandomChars( random, ((Channel *)chan)->userinfo->getPwAnswerLen()-5 );

      pos = (int) ((((Channel *)chan)->userinfo->getPwAnswerLen()-5.0)*rand()/(RAND_MAX+1.0));

      memcpy(tmp, random, pos);
      tmp[pos] = '\0';
      memcpy(tmp2, random+pos, strlen(random)-pos);
      tmp2[strlen(random)-pos] = '\0';

      // Passwort aussenden
      sprintf(str,"%s%s%s\r", tmp, answerstr, tmp2);
      ((Channel *)chan)->sendString( str );
   }

   ((Channel *)chan)->flags |= CH_LINEMODE;

   mode = 0;
}



void Passwords::checkPromptFlexOld( const char *data, int len )
{
   char str[200],*pw,pwd[200], tmp[200];
   int i,passwd=0;


   if ((i = POS(')', data)) == -1) return;
   memmove(str, data+i+1, len-i-1);

   KillSpacesRight( str );
   KillSpacesLeft( str );
   len = strlen(str);

   if ((pw = ((Channel *)chan)->userinfo->getPwd()) == NULL)
   {
      mode = 0;
      return;
   }
   if (atoi(pw) == 0)
   {
      mode = 0;
      return;
   }

   strcpy(pwd, pw);

   if (strlen(pwd) < 5)
   {
      strcpy(tmp, "00000");
      tmp[5-strlen(pwd)] = '\0';
      strcat(tmp, pwd);
      strcpy(pwd, tmp);
   }

   if ((i = POS('>', str)) != -1)
      str[i] = '\0';

   if (strlen(str) < 5)
   {
      strcpy(tmp, "00000");
      tmp[5-strlen(str)] = '\0';
      strcat(tmp, str);
      strcpy(str, tmp);
   }

   for (i=0; i<5; i++)
      passwd += ((str[i]-48)*(pwd[i]-48));

   sprintf(str,"%i\r", passwd);
   ((Channel *)chan)->sendString( str );

   ((Channel *)chan)->flags |= CH_LINEMODE;
   mode = 0;
}


void Passwords::generateRandomChars( char *random, int count )
{
   int pos=0;
   bool ok;
   int answer=((Channel *)chan)->userinfo->getPwAnswer();
   char *pwstr=((Channel *)chan)->userinfo->getPwd();
   char *specified=((Channel *)chan)->userinfo->getPwAnswerStr();
   char ministr[2];


   ministr[1] = '\0';

   while (pos < count)
   {
      ok = false;
      ministr[0] = 1+(int) (255.0*rand()/(RAND_MAX+1.0));

      if ((answer & PWA_AtoZ) != 0)
         if (strstr(AtoZ, ministr) != NULL)
            ok = true;

      if ((answer & PWA_atoz) != 0)
         if (strstr(atoz, ministr) != NULL)
            ok = true;

      if ((answer & PWA_0to9) != 0)
         if (strstr(zahlen, ministr) != NULL)
            ok = true;

      if ((answer & PWA_ALLPWCHARS) != 0)
         if (strstr(pwstr, ministr) != NULL)
            ok = true;

      if ((answer & PWA_SPECIFIED) != 0)
         if (strstr(specified, ministr) != NULL)
            ok = true;


      if (ok)
      {
         random[pos] = ministr[0];
         pos++;
      }
   }
   random[pos] = '\0';
}


void Passwords::checkPromptMD5( const char *data, int len )
{
   int i,k,l;
   char tmp[500],answer[50];


   i = POS('>', data);
   k = POS('[', data);
   l = POS(']', data);

   if ((i < 0) || (k < 0) || (l < 0)) return;

   if (i > k) return;
   if (i > l) return;
   if (k > l) return;

   len = strlen(data)-k-1;
   memcpy(tmp, data+k+1, len);
   tmp[len] = '\0';
   tmp[POS(']', tmp)] = '\0';

   calc_MD5_pw(tmp, ((Channel *)chan)->userinfo->getPwd(), answer);


   strcat(answer, "\r");
   ((Channel *)chan)->sendString( answer );

   mode = 0;
}


void Passwords::calc_MD5_pw(char *MD5prompt, char *MD5pw, char *MD5result)
{
  MD5_CTX context;
  short i, n, len;
  long bc;
  char c1, c2;
  unsigned char *buffp;
  char buff[256];
  short FORLIM;

  buffp =(unsigned char *) buff;
  bc = 0;
  FORLIM = strlen(MD5prompt);
  for (i = 0; i < FORLIM; i++) {
    buffp[bc] = MD5prompt[i];
    bc++;
  }
  FORLIM = strlen(MD5pw);
  for (i = 0; i < FORLIM; i++) {
    buffp[bc] = MD5pw[i];
    bc++;
  }

  buffp[bc] = 0;

  MD5Init(&context);
  len = bc;

  i = 0;

  while (i < len) {
    if (len - i > 16)
      n = 16;
    else
      n = len - i;
    MD5Update(&context, (uchar *)(&buffp[i]), n);
    i += 16;
  }
  MD5Final(&context);

  MD5result[0] = '\0';
  for (i = 0; i <= 15; i++) {
    int2hchar(context.digest[i], &c1, &c2);
    sprintf(MD5result + strlen(MD5result), "%c%c", c1, c2);
  }
  Klein(MD5result);
}


void Passwords::activatePassword()
{
   mode = 1;
   line = 0;

   if (dbtime != NULL)
   {
      free(dbtime);
      dbtime = NULL;
   }
}


void Passwords::checkDieBoxPrompt( const char *data, int len )
{
   char *tmp, tmp2[3];
   unsigned int tag, minute, stunde;


   if (dbtime == NULL)
      if ((tmp = strstr(data, "Login: ")) != NULL)
         if (len-(tmp-data) >= 21)
            if (tmp[9] == '.' && tmp[12] == '.' &&
                tmp[15] == ' ' && tmp[18] == ':')
            {
               memcpy(tmp2, tmp+7, 2);
               tmp2[3] = '\0';
               tag = atoi(tmp2);
               memcpy(tmp2, tmp+16, 2);
               stunde = atoi(tmp2);
               memcpy(tmp2, tmp+19, 2);
               minute = atoi(tmp2);

               dbtime = (struct s_dieboxtime *) malloc(sizeof(struct s_dieboxtime));
               dbtime->tag = tag;
               dbtime->minute = minute;
               dbtime->stunde = stunde;
            }
}


void Passwords::sendTheboxOldPw()
{
   int pos;
   char *cmd = ((Channel *)chan)->userinfo->getPwCommand();
   char *fname = ((Channel *)chan)->userinfo->getPwd();
   int fd, mul;
   char tmp[500];
   char pw[5];


   if (dbtime == NULL)
   {
      KMsgBox::message(NULL, klocale->translate("Failure"),
                             klocale->translate("The TheBox-login-prompt was not received until now."));
      return;
   }


   switch (filesize(fname))
   {
      case 1620:  // Eine Zeile, ohne CR/LF
           mul = 27;
           break;
      case 1680:  // Zeilentrenner entweder CR oder LF
           mul = 28;
           break;
      case 1740:  // Zeilentrenner CR/LF
           mul = 29;
           break;
      default:
           KMsgBox::message(NULL, klocale->translate("Failure"),
                                  klocale->translate("TheBox-password: The specified file is not a TheBox-PW-file."));
           return;
   }


   pos = dbtime->minute + dbtime->tag;
   if (pos > 59) pos -= 60;
   pos = pos * mul + dbtime->stunde;


   if ((fd = open(fname, O_RDONLY)) == -1)
   {
      KMsgBox::message(NULL, klocale->translate("Failure"),
                             klocale->translate("TheBox-password: Cannot open datafile."));
      return;
   }


   mul = lseek(fd, pos, SEEK_SET);
   read(fd, pw, 4);
   pw[4] = '\0';

   close(fd);


   sprintf(tmp, "%s %s\r", cmd, pw);
   ((Channel *)chan)->sendString( tmp );
}



