/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FLAGS_H
#define FLAGS_H


// Diese Flags werden abgespeichert
#define CH_CHECKCONN 1		// Testet Connect-Meldungen
#define CH_CHECKDISC 2		// Testet Disconnect-Meldungen
#define CH_CHECKAUTOBIN 4	// Nach AutoBIN gucken
#define CH_CHECK7PLUS 8		// Nach 7plus gucken
#define CH_AUTOSEND_PW 16  // Automatisch auf Passwort-Abfragen testen?
#define CH_REMOTE 32		   // Remote
#define CH_HUFALLOW 64     // Die Gegenstation darf #HUF# anfordern
#define CH_CHECKDIDADIT 128// Nach DIDADIT gucken (Autosave)
#define CH_ALLOWANSI 256	// ANSI-Codes werden dekodiert


#define CH_DISC 1			// Disconnecte den Link, wen alles gesendet wurde
#define CH_PROMPT 2			// Prompt nach //-Befehlen aussenden?
#define CH_SAVE 4			// Wird gerade ein Textfile gespeichert?
#define CH_7PLUS 8			// Wird gerade ein 7plus-File gespeichert?
#define CH_AUTOBINRX 16			// Wird gerade ein Autobin-File gespeichert?
#define CH_YAPP 32			// Es wird gerade ein YAPP-File transferiert
#define CH_LINEMODE 64			// Daten Zeilenweise oder Frameweise weitergeben?
#define CH_AUTOBINTX 128		// Wird gerade ein Autobin-File gesendet?
#define CH_COMP 256		  	   // Online Huffman-Komprimierung (//COMP = SP)
#define CH_CAN_SEND 512 		// Vertrgt der Treiber auf diesem Kanal noch ein Frame?
#define CH_DIDADIT 1024       // DIDADIT-Uebertragung
#define CH_HUF_TX 2048        // Online Huffman-Komprimierung (#HUF# = TOP)
#define CH_HUF_RX 4096        // Online Huffman-Komprimierung (#HUF# = TOP)

#define TYPE_TERMINAL 1
#define TYPE_MAILBOX 2
#define TYPE_DIGI 3
#define TYPE_CONVERS 4

// Standard-Flags
#define CH_STDFLAGS (CH_PROMPT+CH_LINEMODE+CH_CAN_SEND)
#define CH_UI_STDFLAGS (CH_CHECKCONN+CH_CHECKDISC+CH_CHECKAUTOBIN+CH_CHECK7PLUS+CH_REMOTE+CH_CHECKDIDADIT+CH_ALLOWANSI)

#define FLAGS_SAVE (CH_CHECKCONN+CH_CHECKDISC+CH_CHECKAUTOBIN+CH_CHECK7PLUS+ \
                    CH_AUTOSEND_PW+CH_REMOTE+CH_HUFALLOW+CH_CHECKDIDADIT+CH_ALLOWANSI)
#define FLAGS_STD_TERMINAL (CH_CHECKDISC+CH_CHECKAUTOBIN+CH_CHECK7PLUS+CH_REMOTE+CH_HUFALLOW+CH_CHECKDIDADIT+CH_ALLOWANSI)
#define FLAGS_STD_DIGI (CH_CHECKCONN+CH_CHECKDISC)
#define FLAGS_STD_MAILBOX (CH_CHECKDISC+CH_AUTOSEND_PW+CH_REMOTE+CH_CHECKAUTOBIN+CH_CHECK7PLUS+CH_ALLOWANSI)

// Welche Remote-Befehle duerfen ausgefuehrt werden?
#define REMOTE_QUIT 1
#define REMOTE_VERSION 2
#define REMOTE_CS 4
#define REMOTE_NAME 8
#define REMOTE_COMP 16
#define REMOTE_WRITE 32
#define REMOTE_READ 64
#define REMOTE_INFO 128
#define REMOTE_HELP 256
#define REMOTE_RING 512
#define REMOTE_ECHO 1024
#define REMOTE_RTT 2048
#define REMOTE_DIR 4096
#define REMOTE_NEWS 8192
#define REMOTE_TALK 16384
#define REMOTE_DATE 32768
#define REMOTE_DDATE 65536
#define REMOTE_COOKIE 131072

#define REMOTE_STD_TERMINAL REMOTE_QUIT+REMOTE_VERSION+REMOTE_CS+REMOTE_NAME+ \
                            REMOTE_COMP+REMOTE_WRITE+REMOTE_READ+REMOTE_INFO+ \
                            REMOTE_HELP+REMOTE_RING+REMOTE_ECHO+REMOTE_RTT+ \
                            REMOTE_DIR+REMOTE_NEWS+REMOTE_TALK+REMOTE_DATE+ \
                            REMOTE_DDATE+REMOTE_COOKIE

#define REMOTE_STD_MAILBOX  REMOTE_COMP

#define REMOTE_STD_DIGI     REMOTE_COMP



#define PW_BAYBOX 1
#define PW_FLEXNET_OLD 2
#define PW_DIEBOX 3
#define PW_DIEBOX_OLD 4
#define PW_MD5 5
#define PW_AK1A 6

#define PWA_ALLPWCHARS 1
#define PWA_SPECIFIED 2
#define PWA_AtoZ 4
#define PWA_atoz 8
#define PWA_0to9 16


// Modes aus chanlist.cpp
#define MODE_INFO 0
#define MODE_SETUP 1
#define MODE_DISC 2
#define MODE_7AUTOSAVE 3
#define MODE_AUTOBINRX 4
#define MODE_AUTOBINTX 5
#define MODE_DIDADITRX 6
#define MODE_DIDADITTX 7


// Verschiedene Software, die erkannt wird
#define SW_ANZ 14
#define SW_UNKNOWN 0
// Digi-Software
#define SW_FLEXNET 1
#define SW_AWZNODE 2
#define SW_TNN 3
// Mailbox-Software
#define SW_BAYBOX 1000
#define SW_THEBOX 1001
#define SW_FBB 1002
#define SW_DPBOX 1003
// Terminal-Programme
#define SW_LINKT 2000
#define SW_GP85 2001
#define SW_WINGT 2002
#define SW_MCUT 2003
#define SW_XPACKET 2004
#define SW_WINSTOP 2005

typedef struct
{
   int id;
   char text[20];
} s_swtype;
extern s_swtype swType[SW_ANZ]; // Definiert in channel.cpp



#endif // FLAGS_H

