/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef BOXCHECK_H
#define BOXCHECK_H


#include "global.h"

#include <qobject.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qaccel.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <qlist.h>
#include <qglist.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qcombobox.h>



// Wegen einem bug (?) in qdir.h kann keditcl.h hier nicht included werden.
class KIntLineEdit;


class DlgTransfer : public QDialog
{
   Q_OBJECT;
public:
   DlgTransfer(const char *board, int nr);
   ~DlgTransfer();

	void getInfo( char *board, char *mbx, int & lt );

private:
   QLineEdit *le_board, *le_mbx;
   KIntLineEdit *eLt;
   QLabel *lAt, *lTInfo, *lLt;
   QPushButton *btnSend, *btnAbort;
};


class DlgSetLT : public QDialog
{
   Q_OBJECT;
public:
   DlgSetLT( const char *board, int nr );
   ~DlgSetLT();

   int getLT();

public slots:
   void slotReturn();

private:
   KIntLineEdit *eNewLt;
   QLabel *lNewLt, *lLtInfo;
   QPushButton *btnSend, *btnAbort;

   int newlt;
};


class BoxCheckEntry : public QListViewItem
{
public:
   BoxCheckEntry( QListView *parent, char *line, char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt);
   ~BoxCheckEntry();

//   QString key( int col, bool absteigend );
   const char * key( int col, bool absteigend ) const;

   const char * getBoardName();
   int getMailNr();
	int getLifetime();

private:
	char *board;
   int nr;
   int lt;
   char *sender;
   int size;
};


class BoxCheckWin : public QDialog
{
   Q_OBJECT;

public:
   BoxCheckWin( QObject *prnt, int type, char *title );
   ~BoxCheckWin();

   void resizeEvent(QResizeEvent *event);

	void setFields( int fields );
	void setNewFont();

   void addEntry( char *line, char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt);
   void clear();

public slots:
	void slotSend();
	void slotReadCmd(QListViewItem *item);
	void slotChangeSorting( const char *string );
	void slotTransClicked();
	void slotSetLTClicked();
	void slotReadClicked();
	void slotEraseClicked();

signals:
   void sendString( char *str );

private:
   QObject *parent;
	QListView *liste;
   QComboBox *cmbSort;
   QLabel *lSort;
   QAccel *aLt, *aTr, *aR, *aE;

   int type;
   int sortcol;			// TODO: Ab Qt2 loeschen

   QPushButton *send, *abort;
   QPushButton *btnTrans, *btnSetLT, *btnRead, *btnErase;
};



class BoxCheck : QObject
{
   Q_OBJECT;
public:
   BoxCheck( QWidget *widget );
   ~BoxCheck();

   void readData( const char *desc );
   void proceed( char *str, int len );
   void showWindow();
	void setNewFont();

public slots:
   void sendString( char *str );

private:
   s_boxcheck *data;
   int status;
   QWidget *parent;
   int wronglines;

   BoxCheckWin *win;
};




#endif

