/*
 * ahuf.h
 *
 * Pascal2C-Translation of the #HUF#-Compression by DF... (Andy).
 *
 * Translated by Jochen Sarrazin, DG6VJ
 *
 * Original Pascal-Code is Copyright by Andy, DF...
 * This C-Translation is Copyright by Jochen Sarrazin, DG6VJ (1999)
 */

#ifndef AHUF_H
#define AHUF_H

#define maxBufTyp 768


typedef unsigned char uchar;
typedef unsigned short ushort;


class AHUF
{
public:
   AHUF();
   ~AHUF();

   int Komprimieren( bool flag, char *OBuf, char *zeile, int len);
   int DeKomprimieren( char *OBuf, char *zeile, int len);

private:
   void UpdateCmComp( ushort w, ushort & t, uchar & bl, long & m, uchar & ml, ushort & Count, char *OBuf);
   int Compress( uchar & ml, long & m, ushort & Count, char *OBuf, bool flag, char *zeile, int len);
   int DeCompress( uchar & ml, long & m, ushort & Count, char *OBuf, char *zeile, int len);

   uchar DNotCAnz;
   uchar DNotComp;

   uchar Dml;
   ushort DCount;
   long Dm;

   uchar Cml;
   ushort CCount;
   long Cm;
};


#endif // AHUF_H

