.TH Wharf 1.1 "September 1998" Wharf
.UC
.SH NAME
Wharf \- the AfterStep application "dock" module
.SH SYNOPSIS
Wharf is spawned by afterstep, so no command line invocation will work.
.SH DESCRIPTION
The Wharf module is a free-floating application loader that can
execute programs, "Swallow" running programs, and contain "Folders" of
more applications, among other things.  The user can press the first
button at any time to trigger invocation of one of these functions.  

For users with small displays, the large, beautiful icons used by the
Wharf may consume too much screen area.  Hence there are two methods
for telling Wharf to get out of the way:
.RS
.IP (1)
The *WharfHide configuration option tells Wharf to hide itself most of
the time, popping up temporarily only when the mouse pointer hits a
designated screen edge.  In order to maintain backward compatibility,
the hiding feature is enabled only when the *WharfHide option is
present in the .steprc file.
.IP (2)
The user can press button two in order to cause the entire Wharf to
withdraw to the nearest corner in an iconized state.
.RE

Wharf only works when AfterStep is used as the window manager.
.SH COPYRIGHTS
The Wharf module is copyright 1995 and 1996 by a variety of contributors.
They are, in alphabetical order, Beat Christen, Frank Fejes, Alfredo 
Kenji Kojima, Stephen Ma, Dan Weeks, and Bo Yang.

The GoodStuff program, and the concept for
interfacing this module to the Window Manager, are all original work
by Robert Nation

No guarantees or warranties or anything
are provided or implied in any way whatsoever. Use this program at your
own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact. 
.SH INITIALIZATION
During initialization, \fIWharf\fP will search for a configuration
file which describes the button panel geometry, color, icons, and
actions. The format of 
this file will be described later. The configuration file will be the
one which afterstep used during its initialization.

If the Wharf executable is linked to another name, i.e.

.nf
	ln -s Wharf Pier
.fi

then another module called Pier can be
started, with a completely different configuration than Wharf,
simply by changing the keywords Wharf??? to Pier???. This way multiple
button-bars can be used.
.SH INVOCATION
Wharf can be invoked by inserting the line 'Module Wharf' in
the .steprc file. This can be placed on a line by itself, if Wharf
is to be spawned during AfterStep's initialization, or can be bound to a
menu or mouse button or keystroke to invoke it later. AfterStep will search
directory specified in the ModulePath configuration option to attempt
to locate Wharf.
.SH HIDING THE WHARF
If you have a small display, you may find that the Wharf's large,
beautiful icons consume too much screen area or are too distracting.
You may want the Wharf to stay invisible most of the time, popping up
only when you need it.

Another advantage of an invisible Wharf is that you can afford to make
it as large as you want, since it uses up no screen area most of the
time.  (For example, my Wharf is 16 buttons high and 3 buttons wide.)

If you want an invisible Wharf, use the *WharfHide command; this tells
the Wharf to hide itself until the mouse pointer bumps against a
designated edge of the screen, at which time the Wharf magically
reappears; and when you click on a Wharf button or move the mouse
outside, the Wharf goes away again.  The *WharfHide command is
exhaustively documented in the next section, so there's no need to
repeat everything here.  What I'll offer now is some advice for using
the hiding feature.

Firstly, I strongly recommend that you place the Wharf against the
left edge of the screen.  The reason is that many windows have
scrollbars on the right hand side; if the Wharf is there too, you will
find yourself frequently bumping into the Wharf when you want to
scroll.  This quickly becomes annoying.

To put the Wharf against the left edge of the screen, use the
following commands:

.nf
	*WharfGeometry +0+0
	*WharfHide 3
.fi

If you really must have the Wharf against the right edge of the
screen, use these commands instead:

.nf
	*WharfGeometry -0+0
	*WharfHide 1
.fi

I don't recommend putting the Wharf against the top or bottom of the
screen, as this can interfere with an application window's title bar
(top) or resize bar (bottom).

Secondly, regardless of whether the Wharf is on the left or right, I
recommend that all the Maximize commands in your .steprc file look
like the following:

.nf
	Maximize 100 100
.fi

This causes maximized windows to occupy the whole screen; you can
afford this since the Wharf is hidden most of the time.

Lastly, as I alluded to above, a mostly-invisible Wharf can usefully
be gigantic.  For example, the following commands

.nf
	*WharfRows 16
	*WharfColumns 20
.fi

will set up a 16x20 Wharf containing a total of 320 buttons.  Since
each button can be a folder containing yet more buttons, the mind
boggles at the possibilities.
.SH CONFIGURATION OPTIONS
The following options can be placed in the .steprc file:
.IP "*WharfAnimate"
If specified, the opening and closing of Folders will be animated, 
rather than simply drawn in one frame.

.IP "*WharfAnimateMain"
Designates that full-length Wharf windraws will be animated.

.IP "*WharfBgColor \fIcolor\fP"
If \fI*WharfTextureType 0\fP is specified, \fIWharf\fP's buttons
will be filled with \fIcolor\fP.

.IP "*WharfColumns \fIcolumns\fP"
Specifies the number of columns of buttons to be created. If unspecified,
the number of columns will be set to 1.
If the columns are set to a number greater than 1 then there will be that number
of columns with enough rows to satisfy the requested number of buttons.

.IP "*WharfForceSize"
If specified, will force pixmaps larger than 64x64 to the default
size.  Pixmaps smaller than 64x64 are not supported.

.IP "*WharfFullPush"
If specified, the entire Wharf button background will be moved down
and to the right when pushed.  Especially useful with *WharfNoBorder
textures.

.IP "*WharfHide \fIn\fP"
Tells Wharf to hide itself most of the time, popping up temporarily
when you bump the mouse pointer against a designated edge of the
screen, then hiding again when you click a button or move the mouse
out of the Wharf.  The sensitive part of the screen, called a \fIhot
edge\fP, is given by \fIn\fP:
.nf

  0  top edge
  1  right edge
  2  bottom edge
  3  left edge

.fi
Most people will place the hot edge close to the Wharf, with no more
than one copy of Wharf associated with each hot edge; experience has
shown this to be the most intuitive arrangement.  But there is no
restriction: the association between hot edge and Wharf is completely
arbitrary.

In order to maintain backward compatibility, the hiding feature is off
by default; you \fImust\fP use a *WharfHide command if you want to
hide a Wharf.  Note: this command automatically disables edge
scrolling (see AfterStep's EdgeScroll command).

.IP "*WharfGeometry \fIgeometry\fP"
Specifies the Wharf window location.  The size is ignored; use the
WharfRows and WharfColumns commands instead.  If you use neither
WharfRows nor WharfColumns, Wharf will auto-size itself in a
reasonable manner.  The geometry is a standard X11 window geometry
specification; if you change it, you may wish to adjust the arguments
passed to AfterStep's Maximize command so that maximized windows will
avoid covering the Wharf.  The geometry is pre-set in the NEXTSTEP(tm)
style section for a consistent look and feel with NEXTSTEP(tm).
Secondary Wharf invocations from links may have their own geometry.

.IP "*WharfMaxColors \fInumber\fP"
Specifies the maximum \fInumber\fP of colors to use on a gradient
fill.

.IP "*WharfNoBorder"
Denotes that beveled borders should not be drawn around the Wharf button.
Useful with textures that include their own bevels.

.IP "*WharfPixmap \fIpixmap\fP"
Sets the pixmap file to be used as \fIWharf\fP's button.  To be used
with \fI*WharfTextureType 128\fP.

.IP "*WharfRows \fIcolumns\fP"
Specifies the number of rows of buttons to be created. If unspecified,
the number of rows will be set to 1.  If the rows are set to a number
greater than 1 then there will be that number of rows with enough
columns to satisfy the requested number of buttons.

.IP "*WharfTextureColor \fIfrom\fP \fIto\fP"
When used with a \fI*WharfTextureType\fP of 1 to 5, designates the
ends of the gradient range to be used on \fIWharf\fP's buttons.

.IP "*WharfTextureType  \fItype\fP"
Specifies the type of gradient fill to be used on 
\fIWharf\fP's buttons.  Valid values are:
.nf
0 - No texture - use \fIWharfBgColor\fP to set the desired color
1 - Gradient from upper-left to lower right
2 - Horizontal one way gradient from top to bottom
3 - Horizontal cylindrical gradient from top/bottom to center
4 - Vertical one way gradient from left to right
5 - Vertical cylindrical gradient from left/right to center
128 - User specified pixmap
.fi
The default is the builtin \fIWharf\fP texture pixmap.

.IP "*Wharf \fIlabel icon command\fP"
Specifies a window manager built-in command or folder to activate
(folders will be discussed below), as described in the afterstep
man page, which should be executed when a button is pressed. The label
field is an internal item that is still around from the GoodStuff module.
The icon field
specifies an X11 bitmap file, XPM color icon file, or a comma-delimited 
set of pixmaps containing the
icon(s) to display on the button. Wharf will search through the path
specified in the afterstep IconPath or PixmapPath configuration items to
find the icon file.

NOTE: Icons must have one transparent pixel or the definition of a transparent color in order to be valid.

If \fIcommand\fP is an afterstep Exec command, then the button will
appear pushed in until the mouse button is released.

A single extension to the afterstep built-in command set is provided.
A command of the form:
.nf

*Wharf junk clock.xpm Swallow "Clock" asclock -shape -12 &

.fi
will cause Wharf to spawn an asclock process, and capture 
the first window whose name or resource is "Clock", and display it in
the button-bar. This is handy for applications like xclock, xbiff,
xload, asclock, and asmail. Modules can be swallowed by specifying  SwallowModule instead
of just "swallow" NOTE: if you use xclock for this application, you will want
to specify xclock -padding 0. 

For certain applications that overrun the 48 pixel by 48 pixel boundary of Wharf
icons and Swallowed programs there is a special option called
.I MaxSwallow.
.I MaxSwallow
will allow the application to draw itself larger than the 48x48 boundary.  It is 
invoked the same way Swallow is.

To create folder "slide-outs" in
.B Wharf
the following format must be used:
.nf

*Wharf files Folders.xpm Folder
*Wharf xftp 3DRings.xpm	Exec "" xftp &
*Wharf xdir FolderDeposit.xpm Exec "" xdir &
*Wharf moxfm FilingCabinet.xpm Exec "" moxfm &
*Wharf ~Folders

.fi
The first line of this set tells Wharf that this button definition will be a 
folder.  All of the button definitions between the
.I Folder
and the line with the definition of 
.I *Wharf ~Folders
will appear on the "files" folder when it is exposed.  To expose the "files"
folder simply click on the Wharf button with the Folders.xpm icon showing.  A
button bar will appear perpendicular to your Wharf bar and toward the center
of the screen.  On this smaller bar will be the three icons that were configured 
between the 
.I Folder
and
.I ~Folder
parts of the Wharf configuration.  As many folder buttons may be configured as
is room on your screen.  The only items that may not be configured within
folders are Swallowed applications and more folders.
 
.SH DRAG AND DROP
\fIWharf\fP supports the OffiX Drag and Drop standard.  In order to
have Drag and Drop enabled on a particular button, the following syntax
must be adhered to:
.nf

*Wharf	nil      nil	     DropExec "\fIprogram\fP" \fIprogram\fP %s
*Wharf	\fIprogram\fP  \fIiconname\fP	Exec "\fIprogram\fP" \fIprogram\fP

.fi

The button will call \fIprogram\fP when pushed.  If a file is dragged
onto into it, \fIprogram\fP will be called with %s being replaced by
the dropped filename.

.SH AUTHORS
.nf
Beat Christen (bchriste@iiic.ethz.ch)
Frank Fejes (frank@ssax.com)
Alfredo Kengi Kojima (kojima@inf.ufrgs.br)
Stephen Ma (stephen_ma@mindlink.net)
Dan Weeks (dan@mango.sfasu.edu)
Bo Yang (eric@coeus.ucsd.edu)
.fi
