
/* WARNING: If you change any of these defines, make sure to change
 * the kernel include file as well (i810_drm.h)
 */

#ifndef _XF86DRI_I810_H_
#define _XF86DRI_I810_H_

#ifndef _I810_DEFINES_
#define _I810_DEFINES_
#define I810_USE_BATCH 1

#define I810_DMA_BUF_ORDER     12
#define I810_DMA_BUF_SZ        (1<<I810_DMA_BUF_ORDER)
#define I810_DMA_BUF_NR        256

#define I810_NR_SAREA_CLIPRECTS 2

/* Each region is a minimum of 64k, and there are at most 64 of them.
 */
#define I810_NR_TEX_REGIONS 64
#define I810_LOG_MIN_TEX_REGION_SIZE 16
#endif

Bool drmI810CleanupDma(int driSubFD);
Bool drmI810InitDma(int driSubFD, unsigned long start, unsigned long end, 
		    unsigned long size, int ring_map_idx, int buffer_map_idx, 
		    int sarea_off);
#endif
