/********************************************************************

"THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
PURSUANT TO THE 3DFX FXT1 GENERAL PUBLIC LICENSE. A COPY OF THIS
LICENSE MAY BE OBTAINED FROM THE DISTRIBUTOR OR BY CONTACTING 3DFX
INTERACTIVE INC.  

TO THE EXTENT PERMITTED BY APPLICABLE LAW, THERE IS NO WARRANTY FOR
THIS PROGRAM. THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THIS
PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK
AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD
THIS PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
SERVICING, REPAIR OR CORRECTION.

IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, WILL 3DFX INTERACTIVE,
INC., OR ANY OTHER COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
AND/OR REDISTRIBUTE THIS PROGRAM OR DERIVATIVE WORKS AS PERMITTED
ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THIS PROGRAM OR DERIVATIVE WORKS (INCLUDING BUT NOT
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THIS PROGRAM OR
DERIVATIVE WORKS TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH
HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
THE UNITED STATES.  COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS
RESERVED"

********************************************************************/



/* This plugin can be used with the gimp to import and export fxt1 compressed
 * images. */
#include <gimp.h>

#include <stdlib.h>
#include <stdio.h>
#include <3dfxpb.h>
#include <fximgpb.h>
#include <comppb.h>

#ifdef DEBUG
#define DEBUG_OUT(args) printf args
#else
#define DEBUG_OUT(args)
#endif

/* My plugin exported function */
static void query (void);
static void run (gchar  *name,
		 gint   nparams,
		 GParam *param,
		 gint   *nreturn_vals,
		 GParam **return_vals);


/* This is the importer */
static gint32
load_image (char *filename);

/* This is the exporter */
static gint
save_image (char *filename,
	    gint32 image_ID,
	    gint32 drawable_ID);


/* Registration info */
GPlugInInfo PLUG_IN_INFO = 
{
  NULL,   /* The init proc */
  NULL,   /* The quit proc */
  query,  /* The query proc */
  run,    /* The run proc */ 
};

/* Gimp's plugin main */
MAIN ();


/* Functions for fxt1 import */
static void query (void)
{
  /* Import stuff */
  static GParamDef load_args[] = 
  {
    { PARAM_INT32, "run_mode", "Interactive, non-interactive" },
    { PARAM_STRING, "filename", "The file to load" },
    { PARAM_STRING, "raw_filename", "The name entered" },    
  };
  static GParamDef load_return_vals[] = 
  {
    { PARAM_IMAGE, "image", "Output image" },
  };
  static int nload_args = sizeof (load_args) / sizeof (load_args[0]);
  static int nload_return_vals = sizeof (load_return_vals) / 
    sizeof (load_return_vals[0]);

  /* Export stuff */
  static GParamDef save_args[] = 
  {
    { PARAM_INT32,    "run_mode", "Interactive, non-interactive" },
    { PARAM_IMAGE,    "image", "Input image" },
    { PARAM_DRAWABLE, "drawable", "Input Drawable" },
    { PARAM_STRING,  "filename", "The file to save" },
    { PARAM_STRING,   "raw_filename", "The name entered" },
  };
  static int nsave_args = sizeof (save_args) / sizeof (save_args[0]);

  DEBUG_OUT (("in query\n"));

  gimp_install_procedure ("file_fxt1_load",
			  "Imports FXT1 compressed textures",
			  "FIXME: write help",
			  "Joseph Kain",
			  "3dfx Interactive, Inc.",
			  "1999",
			  "<Load>/fxt1",
			  NULL,
			  PROC_PLUG_IN,
			  nload_args, nload_return_vals,
			  load_args, load_return_vals);
			  

  /* FIXME: register exporter here */
  gimp_install_procedure ("file_fxt1_save",
			  "Exports FXT1 compressed textures",
			  "FIXME: write help",
			  "Joseph Kain",
			  "3dfx Interactive, Inc.",
			  "1999",
			  "<Save>/fxt1",
			  "RGBA",
			  PROC_PLUG_IN,
			  nsave_args, 0,
			  save_args, NULL);

  
	
  gimp_register_magic_load_handler ("file_fxt1_load", "fxt1", "<Load>/fxt1",
				    "o,string,/* fxt1 */");
  gimp_register_save_handler ("file_fxt1_save", "fxt1", "<Save>/fxt1");

}

static void 
run (gchar  *name,
     gint   nparams,
     GParam *param,
     gint   *nreturn_vals,
     GParam **return_vals)
{
  static GParam values[2];
  GRunModeType run_mode;
  gint32 image_ID;
  GStatusType status = STATUS_SUCCESS;

  run_mode = param[0].data.d_int32;
  
  *nreturn_vals = 1;
  *return_vals = values;

  values[0].type = PARAM_STATUS;
  values[0].data.d_status = STATUS_CALLING_ERROR;

  DEBUG_OUT (("running fxt1 importer\n"));

  /* Load an image */
  if (strcmp (name, "file_fxt1_load") == 0)
  {
    image_ID = load_image (param[1].data.d_string);

    if (image_ID != -1)
    {
      *nreturn_vals = 2;
      values[0].data.d_status = STATUS_SUCCESS;
      values[1].type = PARAM_IMAGE;
      values[1].data.d_image = image_ID;
    }
    else
    {
      values[0].data.d_status = STATUS_EXECUTION_ERROR;
    }
  }
  /* Save an image */
  else if (strcmp (name, "file_fxt1_save") == 0)
  {
    switch (run_mode)
    {
    case RUN_NONINTERACTIVE:
      /* Make sure all of the arguments are there */
      if (nparams != 3)
	status = STATUS_CALLING_ERROR;
      break;
    case RUN_INTERACTIVE:
    case RUN_WITH_LAST_VALS:
      /* No extra data */
    default:
      break;
    }
    *nreturn_vals = 1;
    if (save_image (param[3].data.d_string,
		    param[1].data.d_int32,
		    param[2].data.d_int32))
    {
      values[0].data.d_status = STATUS_SUCCESS;
    }
    else
    {
      values[0].data.d_status = STATUS_EXECUTION_ERROR;
    }
  }
  else
    g_assert (FALSE);
}


/* This is the importer */
static gint32
load_image (char *filename)
{
  /* Build an fxt1 info block */
  ImgInfo info;
  CompHeader hd;
  FILE *inf;
  GPixelRgn  pixel_rgn;
  GDrawable *drawable;
  gint32     layer_ID;
  gint32     image_ID;
  guchar     temp;
  gint32     offset;

  inf = fopen (filename, "rb");

  /* Read the header */
  fread (&hd, sizeof (hd), 1, inf);

  /* Setup the header */
  info.any.width = hd.width;
  info.any.height = hd.height;
  info.any.sizeInBytes = sizeof (FxI32) * hd.width * hd.height;
  info.any.data = (unsigned char *)
    calloc(hd.width * hd.height, sizeof(FxI32));

  g_assert (info.any.data);

  decode4x8(&info, inf, 0);

  /* Create a new image */
  image_ID = gimp_image_new (hd.width, 
			     hd.height,
			     RGB);
  /* Name the image */
  gimp_image_set_filename (image_ID, filename);

  /* Add a single layer */
  layer_ID = gimp_layer_new (image_ID,
			     "Color",
			     hd.width,
			     hd.height,
			     RGBA_IMAGE,
			     100,
			     NORMAL_MODE);
  gimp_image_add_layer (image_ID, layer_ID, 0);
  
  /* Get the drawable */
  drawable = gimp_drawable_get (layer_ID);

  gimp_pixel_rgn_init (&pixel_rgn, drawable,
		       0, 0,
		       drawable->width, drawable->height,
		       TRUE, FALSE);

  /* My color bytes are in the wrong order I need to adjust them */
  /* BGRA --> RGBA */
  /* FIXME: I should tile so as to save memory */
  for (offset = 0; offset < hd.width * hd.height * 4; offset += 4)
  {
    temp = info.any.data[offset + 0];
    info.any.data[offset + 0] = info.any.data[offset + 2];
    info.any.data[offset + 2] = temp;
  }

  gimp_pixel_rgn_set_rect (&pixel_rgn, info.any.data, 0, 0,
			   drawable->width, drawable->height);

  gimp_drawable_detach (drawable);

  free (info.any.data);
  fclose (inf);

  return (image_ID);
}

/* Callback for the encoder */
FILE *outf;
int callback_count;
int callback_max;
void fxt1Callback (CCBlock *ccblock, int size)
{
  DEBUG_OUT (("in fxt1Callback: %d\n", callback_count));
  fwrite (ccblock, size, 1, outf);

  /* Update the progress bar */
  gimp_progress_update ((double) callback_count++ / (double) callback_max);
}

/* This is the exporter */
static gint
save_image (char *filename,
	    gint32 image_ID,
	    gint32 drawable_ID)
{
  gchar *name;  
  guchar     temp;
  GDrawable *drawable;
  GPixelRgn  pixel_rgn;
  ImgInfo info;
  CompHeader hd;
  gint32  offset;

  callback_count = 0;

  if (gimp_drawable_type (drawable_ID) == RGBA_IMAGE)
  {
    outf = fopen (filename, "wb");

    /* Get data */
    drawable = gimp_drawable_get (drawable_ID);
    
    /* Put up a progress bar */
    name = g_new (char, strlen (filename) + 12);
    sprintf (name, "Saving %s:", filename);
    gimp_progress_init (name);
    g_free (name);

    /* Get a pixel region */
    gimp_pixel_rgn_init (&pixel_rgn, drawable,
			 0, 0, 
			 drawable->width, drawable->height,
			 TRUE, FALSE);

    /* Setup the header */
    hd.magic = COMP_MAGIC;
    hd.pad = 0;
    hd.width = drawable->width & ~7;
    hd.height = drawable->height & ~3;
    fwrite (&hd, sizeof (hd), 1, outf);

    /* Guess at the number of blocks */
    callback_max = (hd.width / 8) * (hd.height / 4);

    info.any.width = drawable->width;
    info.any.height = drawable->height;
    /* Allocate enough space */
    info.any.data = g_new (guchar, drawable->width * drawable->height * 4);

    /* I need to flip the byte order around for the encoder */
    gimp_pixel_rgn_get_rect (&pixel_rgn, info.any.data, 0, 0,
			     drawable->width, drawable->height);
    for (offset = 0; offset < hd.width * hd.height * 4; offset += 4)
    {
      /* swap Red and Blue */
      temp = info.any.data[offset + 0];
      info.any.data[offset + 0] = info.any.data[offset + 2];
      info.any.data[offset + 2] = temp;
    }    
    encode4x8(&info, fxt1Callback, 0);

    g_free (info.any.data);
    fclose (outf);

    return (TRUE);
  }
  else
  {
    return (FALSE);
  }
}
