#include "gnomeicu.h"
#include "tcp.h"
#include "chatdlg.h"

typedef struct
{
	gpointer data;
	int i;
} dataandint;

void SetForeground( GtkWidget *widget, dataandint *data );
void SetBackground( GtkWidget *widget, dataandint *data );
void CreateSetFGWindow( GtkWidget *widget, gpointer data );
void CreateSetBGWindow( GtkWidget *widget, gpointer data );
void chat_focus_in( gpointer data );
void chat_focus_out( gpointer data );

void SetForeground( GtkWidget *widget, dataandint *data )
{
	static GtkStyle *style = NULL;
	GdkColor *foreground, *background;

	GtkColorSelection *colorsel;
	gdouble color[4];
	BYTE rgb[5];
	int cx;

#ifdef TRACE_FUNCTION
	g_print( "SetForeground\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( data->i == Contacts[ cx ].chat_sok )
			break;
	}

	colorsel = GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( data->data )->colorsel );
	gtk_color_selection_get_color( colorsel, color );

	rgb[0] = 0x00;
	chat_fg_red = rgb[1] = (BYTE)( 255.0F * color[0] );
	chat_fg_green = rgb[2] = (BYTE)( 255.0F * color[1] );
	chat_fg_blue = rgb[3] = (BYTE)( 255.0F * color[2] );
	rgb[4] = 0x00;

	foreground = (GdkColor *)g_malloc( sizeof( GdkColor ) );
	background = (GdkColor *)g_malloc( sizeof( GdkColor ) );

	foreground->red = 256 * chat_fg_red;
	foreground->green = 256 * chat_fg_green;
	foreground->blue = 256 * chat_fg_blue;
	foreground->pixel = (gulong)(
	                    chat_fg_red * 65536 +
	                    chat_fg_green * 256 +
	                    chat_fg_blue );

	background->red = 256 * chat_bg_red;
	background->green = 256 * chat_bg_green;
	background->blue = 256 * chat_bg_blue;
	background->pixel = (gulong)(
	                    chat_bg_red * 65536 +
	                    chat_bg_green * 256 +
	                    chat_bg_blue );

	gdk_color_alloc( gtk_widget_get_colormap( Contacts[ cx ].chat_local_text ), foreground );
	gdk_color_alloc( gtk_widget_get_colormap( Contacts[ cx ].chat_local_text ), background );

	if( style != NULL )
		gtk_style_unref( style );

	style = gtk_style_new();
	style->font = gdk_font_load( ChatFontString );
	if( style->font == NULL )
		style->font = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );
	memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

	gtk_widget_set_style( Contacts[ cx ].chat_local_text, style );
/*	gdk_font_unref( style->font );*/
	
	write( data->i, rgb, 5 );
}

void SetBackground( GtkWidget *widget, dataandint *data )
{
	static GtkStyle *style = NULL;
	GdkColor *foreground, *background;

	GtkColorSelection *colorsel;
	gdouble color[4];
	BYTE rgb[5];
	int cx;

#ifdef TRACE_FUNCTION
	g_print( "SetBackground\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( data->i == Contacts[ cx ].chat_sok )
			break;
	}

	colorsel = GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( data->data )->colorsel );
	gtk_color_selection_get_color( colorsel, color );

	rgb[0] = 0x01;
	chat_bg_red = rgb[1] = (BYTE)( 255.0F * color[0] );
	chat_bg_green = rgb[2] = (BYTE)( 255.0F * color[1] );
	chat_bg_blue = rgb[3] = (BYTE)( 255.0F * color[2] );
	rgb[4] = 0x00;

	foreground = (GdkColor *)g_malloc( sizeof( GdkColor ) );
	background = (GdkColor *)g_malloc( sizeof( GdkColor ) );

	foreground->red = 256 * chat_fg_red;
	foreground->green = 256 * chat_fg_green;
	foreground->blue = 256 * chat_fg_blue;
	foreground->pixel = (gulong)(
	                    chat_fg_red * 65536 +
	                    chat_fg_green * 256 +
	                    chat_fg_blue );

	background->red = 256 * chat_bg_red;
	background->green = 256 * chat_bg_green;
	background->blue = 256 * chat_bg_blue;
	background->pixel = (gulong)(
	                    chat_bg_red * 65536 +
	                    chat_bg_green * 256 +
	                    chat_bg_blue );

	gdk_color_alloc( gtk_widget_get_colormap( Contacts[ cx ].chat_local_text ), foreground );
	gdk_color_alloc( gtk_widget_get_colormap( Contacts[ cx ].chat_local_text ), background );

	if( style != NULL )
		gtk_style_unref( style );

	style = gtk_style_new();
	style->font = gdk_font_load( ChatFontString );
	if( style->font == NULL )
		style->font = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );
	memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

	gtk_widget_set_style( Contacts[ cx ].chat_local_text, style );
/*	gdk_font_unref( style->font );*/

	write( data->i, rgb, 5 );
}

void CreateSetFGWindow( GtkWidget *widget, gpointer data )
{
	dataandint *pass_data = (dataandint *)g_malloc( sizeof( dataandint ) );
	GtkWidget *window;
	window = gtk_color_selection_dialog_new( "Set Foreground Color" );

#ifdef TRACE_FUNCTION
	g_print( "CreateSetFGWindow\n" );
#endif

	pass_data->i = GPOINTER_TO_INT( data );
	pass_data->data = window;

	gtk_color_selection_set_opacity(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	TRUE );
	
	gtk_color_selection_set_update_policy(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	GTK_UPDATE_CONTINUOUS );
	
	gtk_signal_connect(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( SetForeground ), pass_data );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->cancel_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_widget_show( window );
}

void CreateSetBGWindow( GtkWidget *widget, gpointer data )
{
	dataandint *pass_data = (dataandint *)g_malloc( sizeof( dataandint ) );
	GtkWidget *window;
	window = gtk_color_selection_dialog_new( "Set Background Color" );

#ifdef TRACE_FUNCTION
	g_print( "CreateSetBGWindow\n" );
#endif

	pass_data->i = GPOINTER_TO_INT( data );
	pass_data->data = window;

	gtk_color_selection_set_opacity(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	TRUE );
	
	gtk_color_selection_set_update_policy(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	GTK_UPDATE_CONTINUOUS );
	
	gtk_signal_connect(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( SetBackground ), pass_data );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->cancel_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_widget_show( window );
}

GtkWidget *ChatWindowNew( int cindex, int sock )
{
	GtkWidget *box, *hbox, *textbox, *textbox2, *button;
	GtkWidget *scrollbar;
	GtkWidget *table;
	char wintitle[128];

	GtkStyle *style;
	GtkWidget *frame;

	GtkWidget *innertable;

#ifdef TRACE_FUNCTION
	g_print( "ChatWindowNew\n" );
#endif

	Contacts[ cindex ].chat_window = gtk_window_new( GTK_WINDOW_DIALOG );
	sprintf( wintitle, "GnomeICU: %s, %s", ( strlen( our_info->nick ) ? our_info->nick : "User" ), Contacts[ cindex ].nick );
	gtk_window_set_title( GTK_WINDOW( Contacts[ cindex ].chat_window ), wintitle );
	gtk_container_border_width( GTK_CONTAINER( Contacts[ cindex ].chat_window ), 10 );
	gtk_widget_set_usize( Contacts[ cindex ].chat_window, 500, 400 );
	gtk_widget_realize( Contacts[ cindex].chat_window );

	gtk_window_set_policy( GTK_WINDOW( Contacts[ cindex ].chat_window ), TRUE, TRUE, FALSE );

	box = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( Contacts[ cindex ].chat_window ), box );
	gtk_widget_show( box );

	table = gtk_table_new( 2, 1, FALSE );
	gtk_box_pack_start( GTK_BOX( box ), table, TRUE, TRUE, 0 );
	gtk_widget_show( table );

	Contacts[ cindex ].chat_frame = gtk_frame_new( Contacts[ cindex ].nick );
	gtk_container_border_width( GTK_CONTAINER( Contacts[ cindex ].chat_frame ), 5 );
	innertable = gtk_table_new( 1, 2, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( innertable ), 5 );
	gtk_container_add( GTK_CONTAINER( Contacts[ cindex ].chat_frame ), innertable );
	
	textbox = gtk_text_new( NULL, NULL );
	gtk_widget_set_usize( textbox, 300, 175 );
	gtk_text_set_word_wrap( GTK_TEXT( textbox ), TRUE );
	gtk_table_attach( GTK_TABLE( table ), Contacts[ cindex ].chat_frame, 0, 1, 0, 1,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_table_attach( GTK_TABLE( innertable ), textbox, 0, 1, 0, 1,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( innertable );
	gtk_widget_show( Contacts[ cindex ].chat_frame );
	gtk_widget_show( textbox );

	scrollbar = gtk_vscrollbar_new( GTK_TEXT( textbox )->vadj );
	gtk_table_attach( GTK_TABLE( innertable ), scrollbar, 1, 2, 0, 1,
	                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( scrollbar );

	frame = gtk_frame_new( strlen( our_info->nick ) ? our_info->nick : "User" );
	gtk_container_border_width( GTK_CONTAINER( frame ), 5 );
	innertable = gtk_table_new( 1, 2, FALSE );
	gtk_container_set_border_width( GTK_CONTAINER( innertable ), 5 );
	gtk_container_add( GTK_CONTAINER( frame ), innertable );

	textbox2 = gtk_text_new( NULL, NULL );
	gtk_widget_set_usize( textbox2, 300, 175 );
	gtk_text_set_word_wrap( GTK_TEXT( textbox2 ), TRUE );
	gtk_table_attach( GTK_TABLE( table ), frame, 0, 1, 1, 2,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_table_attach( GTK_TABLE( innertable ), textbox2, 0, 1, 0, 1,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
	                  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( innertable );
	gtk_widget_show( frame );
	gtk_widget_show( textbox2 );

	scrollbar = gtk_vscrollbar_new( GTK_TEXT( textbox2 )->vadj );
	gtk_table_attach( GTK_TABLE( innertable ), scrollbar, 1, 2, 0, 1,
	                  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 5 );
	gtk_widget_show( scrollbar );

	gtk_text_set_editable( GTK_TEXT( textbox2 ), TRUE );
	gtk_signal_connect( GTK_OBJECT( textbox2 ), "key_press_event",
	                    GTK_SIGNAL_FUNC( TCPChatSend ), GINT_TO_POINTER( sock ) );

	style = gtk_style_new();
	style->font = gdk_font_load( ChatFontString );
	if( style->font == NULL )
		style->font = gdk_font_load( "-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1" );
	gtk_widget_set_style( textbox, style );
	gtk_widget_set_style( textbox2, style );
	gdk_font_unref( style->font );

	hbox = gtk_hbox_new( FALSE, 0 );

	button = gtk_button_new_with_label( "Set Foreground" );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( CreateSetFGWindow ), GINT_TO_POINTER( sock ) );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 15 );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( "Set Background" );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 15 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( CreateSetBGWindow ), GINT_TO_POINTER( sock ) );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( "Close Chat" );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( TCPTerminateChat ),
	                    GINT_TO_POINTER( sock ) );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( chat_save ), GINT_TO_POINTER( Contacts[ cindex ].uin ) );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                           GTK_SIGNAL_FUNC( gtk_widget_destroy ),
	                           GTK_OBJECT( Contacts[ cindex ].chat_window ) );
	gtk_signal_connect_object( GTK_OBJECT( Contacts[ cindex ].chat_window ),
	                           "focus_in_event",
	                           chat_focus_in,
	                           GINT_TO_POINTER( Contacts[ cindex ].uin ) );

	gtk_signal_connect_object( GTK_OBJECT( Contacts[ cindex ].chat_window ),
	                           "focus_out_event",
	                           chat_focus_out,
	                           GINT_TO_POINTER( Contacts[ cindex ].uin ) );

	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 15 );
	gtk_widget_show( button );

	gtk_box_pack_end( GTK_BOX( box ), hbox, FALSE, FALSE, 0 );
	gtk_widget_show( hbox );

	gtk_widget_show( Contacts[ cindex ].chat_window );

	Contacts[ cindex ].chat_local_text = textbox2;
	Contacts[ cindex ].chat_remote_text = textbox;

	return textbox;
}

void chat_focus_in( gpointer data )
{
	int uin;
	int cx;

	char byte = 0x03;
	
	uin = GPOINTER_TO_INT( data );
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	if( cx == Num_Contacts )
		return;

	if( Contacts[ cx ].chat_active )
		write( Contacts[ cx ].chat_sok, &byte, 1 );
}

void chat_focus_out( gpointer data )
{
	int uin;
	int cx;

	char byte = 0x04;
	
	uin = GPOINTER_TO_INT( data );
	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	if( cx == Num_Contacts )
		return;

	if( Contacts[ cx ].chat_active )
		write( Contacts[ cx ].chat_sok, &byte, 1 );
}
