/*****************************************************************************/
/*  misc_dialogs.c - various dialogs                                         */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

static GdkPixmap *logo_pixmap;
static GdkBitmap *logo_mask;

static void dosite( GtkWidget *widget, struct dialog_data *data);
static void dochange_filespec (GtkWidget *widget, struct dialog_data *data);
static void do_openurl (GtkWidget *widget, struct dialog_data *data);
static void do_reconnect(GtkWidget *widget, struct dialog_data *data);
static void dont_reconnect(GtkWidget *widget, struct dialog_data *data);
static void dosavelog(GtkWidget *widget, GtkFileSelection *fs);

void about_dialog (gpointer data) {
   char *no_license_agreement;
   
   GtkWidget *tempwid, *notebook, *box, *label, *view, *vscroll;
   char tempstr[MAXSTR], *str;
   GtkWidget *dialog;
   FILE *fd;
   
   no_license_agreement = g_strdup_printf (_("Cannot find the license agreement file COPYING. Please make sure it is in either %s or in %s"), BASE_CONF_DIR, SHARE_DIR);
   dialog = gtk_dialog_new ();
   gtk_window_set_title (GTK_WINDOW (dialog), _("About gFTP"));
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), 10);
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);
   gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 5);
   gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), TRUE);
   gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
   gtk_signal_connect_object (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
   gtk_signal_connect_object (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
   gtk_widget_realize (dialog);
      
   notebook = gtk_notebook_new ();
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), notebook, TRUE, TRUE, TRUE);
   gtk_widget_show (notebook);
   
   box = gtk_vbox_new (TRUE, 5);
   gtk_container_border_width (GTK_CONTAINER (box), 10);
   gtk_widget_show (box);
   
   open_xpm ("gftp-logo.xpm", dialog, &logo_pixmap, &logo_mask, 0);
   tempwid = gtk_pixmap_new (logo_pixmap, logo_mask);
   gtk_box_pack_start (GTK_BOX (box), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);

   g_snprintf (tempstr, sizeof (tempstr), _("%s\nCopyright (C) 1998-1999 Brian Masney <masneyb@seul.org>\nOfficial Homepage: http://gftp.seul.org/\nLogo by: Aaron Worley <planet_hoth@yahoo.com>\n"), version);
   tempstr[sizeof (tempstr) - 1] = '\0';
   str = _("Translated by");
   if (strcmp (str, "Translated by") != 0) {
      strncat (tempstr, str, sizeof (tempstr));
      tempstr[sizeof (tempstr) - 1] = '\0';
   }
   tempwid = gtk_label_new (tempstr);
   gtk_box_pack_start (GTK_BOX (box), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);
   
   label = gtk_label_new (_("About"));
   gtk_widget_show (label);
   
   gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box, label);

   box = gtk_vbox_new (FALSE, 5);
   gtk_container_border_width (GTK_CONTAINER (box), 10);
   gtk_widget_show (box);

   tempwid = gtk_table_new (1, 2, FALSE);
   gtk_box_pack_start (GTK_BOX (box), tempwid, TRUE, TRUE, TRUE);
   gtk_widget_show (tempwid);

   view = gtk_text_new (NULL, NULL);
   gtk_text_set_editable (GTK_TEXT (view), FALSE);
   gtk_text_set_word_wrap (GTK_TEXT (view), TRUE);
   gtk_table_attach (GTK_TABLE (tempwid), view, 0, 1, 0, 1,
   	GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
   gtk_widget_show (view);

   vscroll = gtk_vscrollbar_new (GTK_TEXT (view)->vadj);
   gtk_table_attach (GTK_TABLE (tempwid), vscroll, 1, 2, 0, 1,
   	GTK_FILL, GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
   gtk_widget_show (vscroll);

   label = gtk_label_new (_("License Agreement"));
   gtk_widget_show (label);
   
   gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box, label);

   tempwid = gtk_button_new_with_label (_("  Close  "));
   GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), tempwid, FALSE, FALSE, FALSE);
   gtk_signal_connect_object (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
   gtk_widget_grab_default (tempwid);
   gtk_widget_show (tempwid);

   expand_path (SHARE_DIR "/COPYING", tempstr, sizeof (tempstr));
   if (access (tempstr, F_OK) != 0) {
      expand_path (BASE_CONF_DIR "/COPYING", tempstr, sizeof (tempstr));
      if (access (tempstr, F_OK) != 0) {
         strncpy (tempstr, "/usr/doc/copyright/GPL", sizeof (tempstr));
         if (access (tempstr, F_OK) != 0) {
            gtk_text_insert (GTK_TEXT (view), NULL, NULL, NULL, no_license_agreement, strlen (no_license_agreement));
            gtk_widget_show (dialog);
            return;
         }
      }
   }
   if ((fd = fopen (tempstr, "r")) == NULL) {
      gtk_text_insert (GTK_TEXT (view), NULL, NULL, NULL, no_license_agreement, strlen (no_license_agreement));
      gtk_widget_show (dialog);
      return;
   }
   memset (tempstr, 0, sizeof (tempstr));
   while (fread (tempstr, 1, sizeof (tempstr) - 1, fd)) {
      gtk_text_insert (GTK_TEXT (view), NULL, NULL, NULL, tempstr, strlen (tempstr));
      memset (tempstr, 0, sizeof (tempstr));
   }
   fclose (fd);
   gtk_widget_show (dialog);
   g_free (no_license_agreement);
}         
/*****************************************************************************/
void MakeEditDialog (char *diagtxt, char *infotxt, char *deftext, int edit_shown, int erase,
	char *oktxt, void (*okfunc)(), void *okptr,
	char *canceltxt, void (*cancelfunc)(), void *cancelptr) {

   struct dialog_data *d, *cancel_d;
   GtkWidget *tempwid;
   
   d = g_malloc (sizeof (struct dialog_data));
   cancel_d = g_malloc (sizeof (struct dialog_data));
   cancel_d->data = cancelptr;
   d->data = okptr;
   cancel_d->all_buttons = d->all_buttons = NULL;
   d->dialog = cancel_d->dialog = gtk_dialog_new ();
   gtk_grab_add (d->dialog);
   gtk_window_set_title (GTK_WINDOW (d->dialog), diagtxt);
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (d->dialog)->vbox), 10);
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (d->dialog)->action_area), 5);
   gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (d->dialog)->vbox), 5);
   gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (d->dialog)->action_area), 15);
   gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (d->dialog)->action_area), TRUE);
   gtk_window_set_position (GTK_WINDOW (d->dialog), GTK_WIN_POS_MOUSE);
   if (cancelfunc) {
      gtk_signal_connect (GTK_OBJECT (d->dialog), "destroy", GTK_SIGNAL_FUNC (cancelfunc), (gpointer) cancel_d);
   }
   gtk_signal_connect_object (GTK_OBJECT (d->dialog), "destroy", GTK_SIGNAL_FUNC (destroy_dialog_data), (gpointer) cancel_d);
   tempwid = gtk_label_new (infotxt);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (d->dialog)->vbox), tempwid, TRUE, TRUE, FALSE);
   gtk_widget_show (tempwid);
   
   d->edit = cancel_d->edit = gtk_entry_new ();
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (d->dialog)->vbox), d->edit, TRUE, TRUE, FALSE);
   if (okfunc) {
      gtk_signal_connect (GTK_OBJECT (d->edit), "activate", GTK_SIGNAL_FUNC (okfunc), (gpointer) d);
   }
   if (erase || !okfunc) {
      gtk_signal_connect_object (GTK_OBJECT (d->edit), "activate", GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer) d->dialog);
   }
   gtk_widget_grab_focus (d->edit);
   gtk_entry_set_visibility (GTK_ENTRY (d->edit), edit_shown);
   if (deftext != NULL) {
      gtk_entry_set_text (GTK_ENTRY (d->edit), deftext);
      gtk_entry_select_region (GTK_ENTRY (d->edit), 0, strlen (deftext));
   }
   gtk_widget_show (d->edit);

   tempwid = gtk_button_new_with_label (oktxt);
   GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (d->dialog)->action_area), tempwid, TRUE, TRUE, FALSE);
   if (okfunc) {
      gtk_signal_connect (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (okfunc), (gpointer) d);
   }
   if (erase || !okfunc) {
      gtk_signal_connect_object (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer) d->dialog);
   }
   gtk_widget_grab_default (tempwid);
   gtk_widget_show (tempwid);
            
   tempwid = gtk_button_new_with_label (canceltxt);
   GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (d->dialog)->action_area), tempwid, TRUE, TRUE, FALSE);
   if (cancelfunc) {
      gtk_signal_connect (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC(cancelfunc), (gpointer) cancel_d);
   }
   if (erase || !cancelfunc) {
      gtk_signal_connect_object (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer) d->dialog);
   }
   gtk_widget_show (tempwid);

   d->all_buttons = g_list_append (d->all_buttons, d);
   d->all_buttons = g_list_append (d->all_buttons, cancel_d);
   cancel_d->all_buttons = d->all_buttons;
   gtk_widget_show (d->dialog);
}         
/*****************************************************************************/
void MakeYesNoDialog (char *diagtxt, char *infotxt, int erase, int num, ...) {
   GtkWidget *text, *tempwid, *dialog;
   typedef void (*func)();
   struct dialog_data *d;
   func myfunc;
   va_list argp;
   char *tempstr;
   GList *list;
   void *ptr;
   int i;
   
/*FIXME*/
   dialog = gtk_dialog_new ();
   gtk_grab_add (dialog);
   gtk_window_set_title (GTK_WINDOW (dialog), diagtxt);
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), 10);
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);
   gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 5);
   gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->action_area), 15);
   gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), TRUE);
   gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
   
   text = gtk_label_new (infotxt);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), text, TRUE, TRUE, FALSE);
   gtk_widget_show (text);

   list = NULL;
   ptr = g_malloc (1);
   g_list_append (list, ptr);
   va_start (argp, num);
   for (i=0; i<num; i++) {
      tempstr = va_arg (argp, char *);
      myfunc = va_arg (argp, func);
      ptr = va_arg (argp, void *);
      d = g_malloc (sizeof (struct dialog_data));
      g_list_append (list, d);
      d->dialog = dialog;
      d->data = ptr;
      d->all_buttons = list;
      
      tempwid = gtk_button_new_with_label (tempstr);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), tempwid, TRUE, TRUE, TRUE);
      if (myfunc) {
         gtk_signal_connect (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (myfunc), (gpointer) d);
      }
      if (erase || !myfunc) {
         gtk_signal_connect_object (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer) d->dialog);
      }
      gtk_widget_show (tempwid);
   }
            
   gtk_widget_show (dialog);
}         
/*****************************************************************************/
void destroy_dialog_data (struct dialog_data *data) {
   GList *list;
   
   list = data->all_buttons;
   while (list != NULL) {
      if (list->data != data && list->data) g_free (list->data);
      list = list->next;
   }
   g_list_free (data->all_buttons);
   g_free (data);
}
/*****************************************************************************/
void site_dialog (struct ftp_window_data *wdata) {
   if (!check_status (_("Site"), wdata, 0, 0, 1)) return;
         
   MakeEditDialog (_("Site"), _("Enter site-specific command"), NULL, 1, 1,
   	_("OK"), dosite, wdata, 
   	_("  Cancel  "), NULL, NULL);
}
/*****************************************************************************/
static void dosite (GtkWidget *widget, struct dialog_data *data) {
   struct ftp_window_data *wdata;
   char *edttext;

   wdata = (struct ftp_window_data *) data->data;
   edttext = gtk_entry_get_text (GTK_ENTRY (data->edit));
   if (*edttext == '\0') {
      ftp_log (gftp_logging_misc, NULL, _("SITE: Operation canceled...you must enter a string\n"));
      return;
   }
   if ((wdata->local == 2) && !ftp_connect (wdata->hdata, 0)) return;
   gftp_site_cmd (wdata->hdata->ftpdata, edttext);
}
/*****************************************************************************/
void change_filespec (struct ftp_window_data *wdata) {
   if (!check_status (_("Change Filespec"), wdata, 0, 0, 0)) return;

   if (wdata->local == -1) {
      ftp_log (gftp_logging_misc, NULL, _("Change Filespec: Not connected to a remote site\n"));
      return;
   }
   MakeEditDialog (_("Change Filespec"), _("Enter the new file specification"), wdata->filespec, 1, 1,
      _("Change"), dochange_filespec, wdata,
      _("  Cancel  "), NULL, NULL);
}
/*****************************************************************************/
static void dochange_filespec (GtkWidget *widget, struct dialog_data *data) {
   struct ftp_file_data *tempfle;
   struct ftp_window_data *wdata;
   char *edttext;

   wdata = (struct ftp_window_data *) data->data;
   edttext = gtk_entry_get_text (GTK_ENTRY(data->edit));
   if (*edttext == '\0') {
     ftp_log (gftp_logging_misc, NULL, _("Change Filespec: Operation canceled...you must enter a string\n"));
     return;
   }
   if (wdata->filespec) g_free (wdata->filespec);
   wdata->filespec = g_malloc (strlen (edttext) + 1);
   strcpy (wdata->filespec, edttext);
   wdata->numselected = 0;

   gtk_clist_freeze (GTK_CLIST (wdata->listbox));
   gtk_clist_clear (GTK_CLIST (wdata->listbox));
   tempfle = wdata->hdata->files;
   while (tempfle != NULL) {
      add_file_listbox (wdata, tempfle);
      tempfle = tempfle->next;
   }
   gtk_clist_thaw (GTK_CLIST (wdata->listbox));
   update_ftp_info (wdata);
}
/*****************************************************************************/
void openurl_dialog (gpointer data) {
   char *edttxt;
   
   edttxt = gtk_entry_get_text (GTK_ENTRY (hostedit));
   if (window2.local != -1) disconnect (&window2);
   else if (edttxt != NULL && *edttxt != '\0') toolbar_hostedit (NULL, NULL);
   else {
      MakeEditDialog (_("Connect via URL"), _("Enter ftp url to connect to"), NULL, 1, 0,
      		_("Connect"), do_openurl, &window2, _("  Cancel  "), NULL, NULL);
   }
}
/*****************************************************************************/
static void do_openurl (GtkWidget *widget, struct dialog_data *data) {
   struct ftp_window_data *wdata;
   char *tempstr;
   
   wdata = (struct ftp_window_data *) data->data;
   tempstr = gtk_entry_get_text (GTK_ENTRY (data->edit));
   if (gftp_parse_url (wdata->hdata->ftpdata, tempstr) == 0) {
      gtk_widget_destroy (data->dialog);
      if (GFTP_GET_PASSWORD (wdata->hdata->ftpdata) == NULL) {
         gftp_set_password (wdata->hdata->ftpdata, emailaddr);
      }
      if (wdata->local != -1) disconnect (wdata);
      ftp_connect (wdata->hdata, 1);
   }
   else {
      gtk_widget_destroy (data->dialog);
      ftp_log (gftp_logging_misc, NULL, _("Could not parse URL %s\n"), tempstr);
   }
}
/*****************************************************************************/
void openurl_get_drag_data (GtkWidget *widget, GdkDragContext *context, gint x, 
	gint y, GtkSelectionData *selection_data, guint info, guint32 clk_time, 
	struct ftp_window_data *wdata) {

   if ((selection_data->length >= 0) && (selection_data->format == 8)) {
      if (gftp_parse_url (window2.hdata->ftpdata, selection_data->data) == 0) {
         if (window2.local != -1) disconnect (&window2);
         ftp_connect (window2.hdata, 1);
      }
      else ftp_log (gftp_logging_misc, NULL, _("Could not parse URL %s\n"), selection_data->data);
   }
}
/*****************************************************************************/
void reconnect_dialog (struct ftp_host_data *hdata) {
   char *tempstr;

   tempstr = g_strdup_printf (_("Error: Could not connect to host %s. What would you like to do?"), GFTP_GET_HOSTNAME (hdata->ftpdata));
   MakeYesNoDialog (_("Reconnect"), tempstr, 0, 2,
   	_("Retry Connection"), do_reconnect, hdata,
   	_("  Cancel  "), dont_reconnect, hdata);
   g_free (tempstr);
}
/*****************************************************************************/
static void do_reconnect (GtkWidget *widget, struct dialog_data *data) {
   struct ftp_host_data *hdata;
   
   hdata = (struct ftp_host_data *) data->data;
   gtk_widget_destroy (data->dialog);
   ftp_connect (hdata, 1);
}
/*****************************************************************************/
static void dont_reconnect (GtkWidget *widget, struct dialog_data *data) {
   struct ftp_host_data *hdata;
   
   hdata = (struct ftp_host_data *) data->data;
   gtk_widget_destroy (data->dialog);
   hdata->wait = 0;
}
/*****************************************************************************/
void viewlog (gpointer data) {
   char tempstr[MAXSTR], *txt;
   guint textlen;
   FILE *fd;

   make_temp_filename (tempstr, NULL, sizeof (tempstr));
   if ((fd = fopen (tempstr, "w")) == NULL) {
      ftp_log (gftp_logging_misc, NULL, _("Error: Cannot open %s: %s\n"), tempstr, g_strerror (errno));
      return;
   }
   textlen = gtk_text_get_length (GTK_TEXT (logwdw));
   txt = gtk_editable_get_chars (GTK_EDITABLE (logwdw), 0, -1);
   if (!fwrite (txt, 1, textlen, fd)) {
      ftp_log (gftp_logging_misc, NULL, _("Error: Error writing to %s\n"), tempstr);
   }
   fclose (fd);
   view_file (tempstr, 1, 1, 0, NULL);
}
/*****************************************************************************/
void savelog (gpointer data) {
   GtkWidget *filew;
   
   filew = gtk_file_selection_new (_("Save Log"));

   gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button), "clicked", GTK_SIGNAL_FUNC (dosavelog), filew);
   gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (filew));
   gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (filew));
   gtk_file_selection_set_filename (GTK_FILE_SELECTION (filew), "gftp.log");
   gtk_widget_show (filew);
}
/*****************************************************************************/
static void dosavelog (GtkWidget *widget, GtkFileSelection *fs) {
   char *filename, *txt;
   guint textlen;
   FILE *fd;

   filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
   if ((fd = fopen (filename, "w")) == NULL) {
      ftp_log (gftp_logging_misc, NULL, _("Error: Cannot open %s: %s\n"), filename, g_strerror (errno));
      return;
   }
   textlen = gtk_text_get_length (GTK_TEXT (logwdw));
   txt = gtk_editable_get_chars (GTK_EDITABLE (logwdw), 0, -1);
   if (!fwrite (txt, 1, textlen, fd)) {
      ftp_log (gftp_logging_misc, NULL, _("Error: Error writing to %s\n"), filename);
   }
   else {
      ftp_log (gftp_logging_misc, NULL, _("Successfully wrote the log file to %s\n"), filename);
   }
   fclose (fd);
   g_free (txt);
}
/*****************************************************************************/
void clearlog (gpointer data) {
   guint pos;
   
   pos = gtk_text_get_length (GTK_TEXT (logwdw));
   gtk_text_set_point (GTK_TEXT (logwdw), pos);
   gtk_text_backward_delete (GTK_TEXT (logwdw), pos);
}
/*****************************************************************************/
