#include "E.h"

ToolTip            *
CreateToolTip(char *name, ImageClass * ic0, ImageClass * ic1, ImageClass * ic2,
	      ImageClass * ic3, ImageClass * ic4, TextClass * tclass, int dist,
	      ImageClass * tooltippic)
{
  ToolTip            *tt;

  EDBUG(5, "CreateToolTip");
  tt = Emalloc(sizeof(ToolTip));
  tt->name = duplicate(name);
  tt->iclass = ic0;
  tt->tooltippic = NULL;
  if (tooltippic)
    tt->tooltippic = tooltippic;
  if (!tt->iclass)
    {
      if (tt->name)
	Efree(tt->name);
      if (tt)
	Efree(tt);
      EDBUG_RETURN((ToolTip *) NULL);
    }
  tt->s_iclass[0] = ic1;
  if (!tt->s_iclass[0])
    {
      if (tt->name)
	Efree(tt->name);
      if (tt)
	Efree(tt);
      EDBUG_RETURN((ToolTip *) NULL);
    }
  tt->s_iclass[1] = ic2;
  if (!tt->s_iclass[1])
    {
      if (tt->name)
	Efree(tt->name);
      if (tt)
	Efree(tt);
      EDBUG_RETURN((ToolTip *) NULL);
    }
  tt->s_iclass[2] = ic3;
  if (!tt->s_iclass[2])
    {
      if (tt->name)
	Efree(tt->name);
      if (tt)
	Efree(tt);
      EDBUG_RETURN((ToolTip *) NULL);
    }
  tt->s_iclass[3] = ic4;
  if (!tt->s_iclass[3])
    {
      if (tt->name)
	Efree(tt->name);
      if (tt)
	Efree(tt);
      EDBUG_RETURN((ToolTip *) NULL);
    }
  tt->tclass = tclass;
  if (!tt->tclass)
    {
      if (tt->name)
	Efree(tt->name);
      if (tt)
	Efree(tt);
      EDBUG_RETURN((ToolTip *) NULL);
    }
  tt->dist = dist;
  tt->win = ECreateWindow(root.win, -10, -100, 1, 1, 1);
  tt->iwin = ECreateWindow(tt->win, -10, -100, 1, 1, 1);
  tt->s_win[0] = ECreateWindow(root.win, -10, -100, 8, 8, 1);
  tt->s_win[1] = ECreateWindow(root.win, -10, -100, 16, 16, 1);
  tt->s_win[2] = ECreateWindow(root.win, -10, -100, 24, 24, 1);
  tt->s_win[3] = ECreateWindow(root.win, -10, -100, 32, 32, 1);
  tt->visible = 0;
  EDBUG_RETURN(tt);
}

void
ShowToolTip(ToolTip * tt, char *text, int x, int y)
{
  int                 w, h, ix, iy, iw, ih, dx, dy, xx, yy;
  int                 ww, hh, adx, ady, dist, tw, th;
  ImlibImage         *im;
  char                pq;

  EDBUG(5, "ShowToolTip");
  if (!tt)
    EDBUG_RETURN_;

  pq = queue_up;
  queue_up = 0;

  TextSize(tt->tclass, 0, 0, STATE_NORMAL, text, &w, &h, 17);
  tw = w;
  th = h;
  iw = 0;
  ih = 0;
  if (tt->tooltippic)
    {
      im = ELoadImage(tt->tooltippic->norm.normal->im_file);
      ix = 0;
      iy = 0;
      if (im)
	{
	  iw = im->rgb_width;
	  ih = im->rgb_height;
	  Imlib_destroy_image(id, im);
	}
      w += iw;
      if (h < ih)
	h = ih;
    }

  w += tt->iclass->padding.left + tt->iclass->padding.right;
  h += tt->iclass->padding.top + tt->iclass->padding.bottom;

  if ((tt->tooltippic) && (iw > 0) && (ih > 0))
    {
      ix = tt->iclass->padding.left;
      iy = (h - ih) / 2;
      XMoveResizeWindow(disp, tt->iwin, ix, iy, iw, ih);
      XMapWindow(disp, tt->iwin);
      IclassApply(tt->tooltippic, tt->iwin, iw, ih, 0, 0, STATE_NORMAL, 0);
    }
  else
    XUnmapWindow(disp, tt->iwin);

  dx = x - root.w / 2;
  dy = y - root.h / 2;

  if ((dy == 0) && (dx == 0))
    dy = -1;

  adx = dx;
  if (adx < 0)
    adx = -adx;
  ady = dy;
  if (ady < 0)
    ady = -ady;
  if (adx < ady)
    /*   +-------+   */
    /*   |\#####/|   */
    /*   | \###/ |   */
    /*   |  \#/  |   */
    /*   |  /#\  |   */
    /*   | /###\ |   */
    /*   |/#####\|   */
    /*   +-------+   */
    {
      dist = tt->dist;
      ady = ady / dy;
      yy = y - ((ady * 10 * dist) / 100);
      xx = x - (dist * 10 * dx) / (100 * root.w / 2);
      XMoveWindow(disp, tt->s_win[0], xx - 4, yy - 4);
      yy = y - ((ady * 30 * dist) / 100);
      xx = x - (dist * 30 * dx) / (100 * root.w / 2);
      XMoveWindow(disp, tt->s_win[1], xx - 8, yy - 8);
      yy = y - ((ady * 50 * dist) / 100);
      xx = x - (dist * 50 * dx) / (100 * root.w / 2);
      XMoveWindow(disp, tt->s_win[2], xx - 12, yy - 12);
      yy = y - ((ady * 80 * dist) / 100);
      xx = x - (dist * 80 * dx) / (100 * root.w / 2);
      XMoveWindow(disp, tt->s_win[3], xx - 16, yy - 16);
      yy = y - ((ady * 100 * dist) / 100);
      xx = x - (dist * 100 * dx) / (100 * root.w / 2);
      if (ady < 0)
	hh = 0;
      else
	hh = h;
      ww = (w / 2) + ((dx * w) / (root.w / 2));
      XMoveResizeWindow(disp, tt->win, xx - ww, yy - hh, w, h);
    }
  else
    /*   +-------+   */
    /*   |\     /|   */
    /*   |#\   /#|   */
    /*   |##\ /##|   */
    /*   |##/ \##|   */
    /*   |#/   \#|   */
    /*   |/     \|   */
    /*   +-------+   */
    {
      if (dx == 0)
	{
	  dx = 1;
	  adx = 1;
	}
      dist = tt->dist;
      adx = adx / dx;
      xx = x - ((adx * 10 * dist) / 100);
      yy = y - (dist * 10 * dy) / (100 * root.h / 2);
      XMoveWindow(disp, tt->s_win[0], xx - 4, yy - 4);
      xx = x - ((adx * 30 * dist) / 100);
      yy = y - (dist * 30 * dy) / (100 * root.h / 2);
      XMoveWindow(disp, tt->s_win[1], xx - 8, yy - 8);
      xx = x - ((adx * 50 * dist) / 100);
      yy = y - (dist * 50 * dy) / (100 * root.h / 2);
      XMoveWindow(disp, tt->s_win[2], xx - 12, yy - 12);
      xx = x - ((adx * 80 * dist) / 100);
      yy = y - (dist * 80 * dy) / (100 * root.h / 2);
      XMoveWindow(disp, tt->s_win[3], xx - 16, yy - 16);
      xx = x - ((adx * 100 * dist) / 100);
      yy = y - (dist * 100 * dy) / (100 * root.h / 2);
      if (adx < 0)
	ww = 0;
      else
	ww = w;
      hh = (h / 2) + ((dy * h) / (root.h / 2));
      XMoveResizeWindow(disp, tt->win, xx - ww, yy - hh, w, h);
    }
  IclassApply(tt->s_iclass[0], tt->s_win[0], 8, 8, 0, 0, STATE_NORMAL, 0);
  IclassApply(tt->s_iclass[1], tt->s_win[1], 16, 16, 0, 0, STATE_NORMAL, 0);
  IclassApply(tt->s_iclass[2], tt->s_win[2], 24, 24, 0, 0, STATE_NORMAL, 0);
  IclassApply(tt->s_iclass[3], tt->s_win[3], 32, 32, 0, 0, STATE_NORMAL, 0);
  IclassApply(tt->iclass, tt->win, w, h, 0, 0, STATE_NORMAL, 0);
  XMapRaised(disp, tt->s_win[0]);
  XMapRaised(disp, tt->s_win[1]);
  XMapRaised(disp, tt->s_win[2]);
  XMapRaised(disp, tt->s_win[3]);
  XMapRaised(disp, tt->win);
  XSync(disp, False);

  TextDraw(tt->tclass, tt->win, 0, 0, STATE_NORMAL, text,
	   tt->iclass->padding.left + iw, tt->iclass->padding.top,
	   tw, th, 17, 512);
  queue_up = pq;
  tt->visible = 1;
  EDBUG_RETURN_;
}

void
HideToolTip(ToolTip * tt)
{
  EDBUG(5, "HideToolTip");
  if (!tt)
    EDBUG_RETURN_;

  if (!tt->visible)
    EDBUG_RETURN_;
  tt->visible = 0;
  XUnmapWindow(disp, tt->win);
  XUnmapWindow(disp, tt->s_win[0]);
  XUnmapWindow(disp, tt->s_win[1]);
  XUnmapWindow(disp, tt->s_win[2]);
  XUnmapWindow(disp, tt->s_win[3]);
  XSync(disp, False);
  EDBUG_RETURN_;
}
