
/* This file should only be included if REALLY_HAVE_TERMIOS_H is defined. */

#include <termios.h>
#ifdef sun
# ifndef PENDIN
#  include <sys/ioctl.h>
# endif
#else
# include <sys/ioctl.h>
#endif

#include <errno.h>

static int pty_setup_slave_term (int slave, int raw)
{
   struct termios slave_termios;
   
   while (-1 == tcgetattr (slave, &slave_termios))
     {
#ifdef EINTR
	if (errno == EINTR)
	  continue;
#endif
	return -1;
     }
   
   slave_termios.c_lflag = 0;

   if (raw == 0)
     slave_termios.c_lflag |= ICANON;

   slave_termios.c_iflag &= ~(ECHO | INLCR | ICRNL);
#ifdef ONLRET
   slave_termios.c_oflag |= ONLRET;
#endif
#ifdef ONLCR
   slave_termios.c_oflag &= ~ONLCR;
#endif
   slave_termios.c_cc[VEOF] = 4;
   slave_termios.c_cc[VMIN] = 1;
   slave_termios.c_cc[VTIME] = 0;
    
   while (-1 == tcsetattr (slave, TCSANOW, &slave_termios))
     {
#ifdef EINTR
	if (errno == EINTR)
	  continue;
#endif
	return -1;
     }

   return 0;
}


static int pty_open_pty (int *master, char *slave_tty_name)
{
   char *a, *b;
   
   strcpy (slave_tty_name, "/dev/ptyab");
   
   a = "pqrstuvwxyz";
   while (*a != 0)
     {
	slave_tty_name [8] = *a++;
	
	b = "0123456789abcdef";
	while (*b != 0)
	  {
	     int slave;

	     slave_tty_name [9] = *b++;
	     if (-1 == (*master = signal_safe_open (slave_tty_name, O_RDWR)))
	       continue;
	     
	     /* Make sure the slave can be opened.   I attempt to set up
	      * the master terminal also even though it is not a tty and will
	      * probably fail.
	      */
	     slave_tty_name [5] = 't';
	     if (-1 != (slave = open (slave_tty_name, O_RDWR)))
	       {
		  signal_safe_close (slave);
		  (void) pty_setup_slave_term (*master, 1);
		  return 0;
	       }
		  
	     signal_safe_close (*master);
	     slave_tty_name [5] = 'p';
	  }
     }
   return -1;
}



