/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    public FileInputStream(String string) throws FileNotFoundException {
        System.getSecurityManager().checkRead(string);
        try {
            this.fd = new FileDescriptor();
            this.open(string);
            return;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string);
        }
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        System.getSecurityManager().checkRead(fileDescriptor);
        this.fd = fileDescriptor;
    }

    private native void open(String var1) throws IOException;

    public native int read() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public native long skip(long var1) throws IOException;

    public native int available() throws IOException;

    public native void close() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }
}

