// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// File   : HiScore.h[1.0]
// Name   : gamelib1.0
// Status : proposed
// Changed: Sun Jun 12 22:19:15 1994


// This is the object to do all of the hiscore work

#ifndef __BPHiScore__
#define __BPHiScore__

#include <String.h>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#define HiScoreListSize	10
#define MaxNameLength	20

// pad a string out on the right to at least 'len' chars
void rPad(String &str, int len);

typedef unsigned int Score;

class HiScore {

    public:
    
	HiScore( const char *file );
	~HiScore();    
    
    	// return pos in list if score is good enough to be placed on
    	// list, -1 otherwise
    	char isHigh( Score s ) const;
    	
    	// add name/score to high score list. Returns 1 if ok, 0 otherwise
	char add( const String n, Score s) { return add( (const char *)n , s); }
    	char add( const char *name, Score s );
    	
    	// return name of i'th person on list
    	String name( int i ) const
    		{
    		if (inRange(i)) return Vname[i];
    		else return "";
    		}
    	
    	// return score 
    	Score score( int i ) const
    		{
    		if (inRange(i)) return Vscore[i];
    		else return 0;
    		}
    	
    	// return string of person's name and score
    	String operator[] (int i) const
    		{
		String result="";
    		if (inRange(i))
    			{
    			char buf[10];
    			sprintf(buf,"%d",Vscore[i]);
    			
    			result = Vname[i];
    			rPad(result, MaxNameLength);
    			result += " ";
    			result += buf;
    			}
		return result;
    		}

	// save high scores to disk.. done in destructor too
	// returns EXIT_SUCCESS, or EXIT_FAILURE
	char save();
    	
    private:
    
	String	Vname[HiScoreListSize];
	Score	Vscore[HiScoreListSize];

	String	Vfile;
	
	// check for proper index in high score list
	// index starts at 0 to keep with C array conventions.
	char inRange(int i) const
		{
		if ( (i>=0) && (i<(HiScoreListSize)) ) return 1;
		else return 0;
		}    

	// routine to read in the old text format for high score
	// files, for backwards-compatibility.
	void readOldFormat();
	
    };

#endif
