.TH MAKE 1L "22 August 1989" "GNU" "LOCAL USER COMMANDS"
.SH NAME
make \- GNU make utility to maintain groups of programs
.SH SYNOPSIS
.B "make "
[
.B \-f
makefile ] [ option ] ...
target ...
.SH WARNING
This man page is an extract of the documentation of
.I GNU make .
It is updated only occasionally, because the GNU project does not use nroff.
For complete, current documentation, refer to the Info file
.B make
or the DVI file
.B make.dvi
which are made from the Texinfo source file
.BR make.texinfo .
.SH DESCRIPTION
.LP
The purpose of the
.I make
utility is to determine automatically which
pieces of a large program need to be recompiled, and issue the commands to
recompile them.
This manual describes the GNU implementation of
.IR make ,
which was written by Richard Stallman and Roland McGrath.
Our examples show C programs, since they are most common, but you can use
.I make
with any programming language whose compiler can be run with a
shell command.
In fact,
.I make
is not limited to programs.
You can use it to describe any task where some files must be
updated automatically from others whenever the others change.
.LP
To prepare to use
.IR make ,
you must write a file called the
.I makefile
that describes the relationships among files in your program, and the
states the commands for updating each file.
In a program, typically the executable file is updated from object
files, which are in turn made by compiling source files.
.LP
Once a suitable makefile exists, each time you change some source files,
this simple shell command:
.sp 1
.RS
.B make
.RE
.sp 1
suffices to perform all necessary recompilations.
The
.I make
program uses the makefile data base and the last-modification times
of the files to decide which of the files need to be updated.
For each of those files, it issues the commands recorded in the data base.
.LP
.I make
executes commands in the
.I makefile
to update
one or more target
.IR names ,
where
.I name
is typically a program.
If no
.B \-f
option is present,
.I make
will look for the makefiles
.IR GNUmakefile ,
.IR makefile ,
and
.IR Makefile ,
in that order.
.LP
Normally you should call your makefile either
.I makefile
or
.IR Makefile .
(We recommend
.I Makefile
because it appears prominently near the beginning of a directory
listing, right near other important files such as
.IR  README .)
The first name checked,
.IR GNUmakefile ,
is not recommended for most makefiles.
You should use this name if you have a makefile that is specific to GNU
.IR make ,
and will not be understood by other versions of
.IR make .
If
.I makefile
is `\-', the standard input is read.
.LP
.I make
updates a target if it depends on prerequisite files
that have been modified since the target was last modified,
or if the target does not exist.
.SH OPTIONS
.sp 1
.TP 0.5i
.B \-b
.TP 0.5i
.B \-m
These options are ignored for compatibility with other versions of
.IR make .
.TP 0.5i
.BI "\-C " dir
Change to directory
.I dir
before reading the makefiles or doing anything else.
If multiple
.B \-C
options are specified, each is interpreted relative to the
previous one:
.BR "\-C " /
.BR "\-C " etc
is equivalent to
.BR "\-C " /etc.
This is typically used with recursive invocations of
.IR make .
.TP 0.5i
.B \-d
Print debugging information in addition to normal processing.
The debugging information says which files are being considered for
remaking, which file-times are being compared and with what results,
which files actually need to be remade, which implicit rules are
considered and which are applied---everything interesting about how
.I make
decides what to do.
.TP 0.5i
.B \-e
Give variables taken from the environment precedence
over variables from makefiles.
.TP 0.5i
.BI "\-f " file
Use
.I file
as a makefile.
.TP 0.5i
.B \-i
Ignore all errors in commands executed to remake files.
.TP 0.5i
.BI "\-I " dir
Specifies a directory
.I dir
to search for included makefiles.
If several
.B \-I
options are used to specify several directories, the directories are
searched in the order specified.
Unlike the arguments to other flags of
.IR make ,
directories given with
.B \-I
flags may come directly after the flag:
.BI \-I dir
is allowed, as well as
.BI "\-I " dir.
This syntax is allowed for compatibility with the C
preprocessor's
.B \-I
flag.
.TP 0.5i
.BI "\-j " jobs
Specifies the number of jobs (commands) to run simultaneously.
If there is more than one
.B \-j
option, the last one is effective.
If the
.B \-j
option is given without an argument,
.IR make
will not limit the number of jobs that can run simultaneously.
.TP 0.5i
.B \-k
Continue as much as possible after an error.
While the target that failed, and those that depend on it, cannot
be remade, the other dependencies of these targets can be processed
all the same.
.TP 0.5i
.B \-l
.TP 0.5i
.BI "\-l " load
Specifies that no new jobs (commands) should be started if there are
others jobs running and the load average is at least
.I load
(a floating-point number).
With no argument, removes a previous load limit.
.TP 0.5i
.B \-n
Print the commands that would be executed, but do not execute them.
.TP 0.5i
.BI "\-o " file
Do not remake the file
.I file
even if it is older than its dependencies, and do not remake anything
on account of changes in
.IR file .
Essentially the file is treated as very old and its rules are ignored.
.TP 0.5i
.B \-p
Print the data base (rules and variable values) that results from
reading the makefiles; then execute as usual or as otherwise
specified.
This also prints the version information given by the
.B \-v
switch (see below).
To print the data base without trying to remake any files, use
.B make
.B \-p
.BI \-f /dev/null.
.TP 0.5i
.B \-q
``Question mode''.
Do not run any commands, or print anything; just return an exit status
that is zero if the specified targets are already up to date, nonzero
otherwise.
.TP 0.5i
.B \-r
Eliminate use of the built-in implicit rules.
Also clear out the default list of suffixes for suffix rules.
.TP 0.5i
.B \-s
Silent operation; do not print the commands as they are executed.
.TP 0.5i
.B \-S
Cancel the effect of the
.B \-k
option.
This is never necessary except in a recursive
.I make
where
.B \-k
might be inherited from the top-level
.I make
via MAKEFLAGS or if you set
.B \-k
in MAKEFLAGS in your environment.
.TP 0.5i
.B \-t
Touch files (mark them up to date without really changing them)
instead of running their commands.
This is used to pretend that the commands were done, in order to fool
future invocations of
.IR make .
.TP 0.5i
.B \-v
Print the version of the
.I make
program plus a copyright, a list of authors and a notice that there
is no warranty.
After this information is printed, processing continues normally.
To get this information without doing anything else, use
.B make
.B \-v
.BI \-f /dev/null.
.TP 0.5i
.B \-w
Print a message containing the working directory
before and after other processing.
This may be useful for tracking down errors from complicated nests of
recursive
.I make
commands.
.TP 0.5i
.BI "\-W " file
Pretend that the target
.I file
has just been modified.
When used with the
.B \-n
flag, this shows you what would happen if you were to modify that file.
Without
.BR \-n ,
it is almost the same as running a
.I touch
command on the given file before running
.IR make ,
except that the modification time is changed only in the imagination of
.IR make .
.SH "SEE ALSO"
.PD 0
.TP 2.0i
/usr/local/doc/gnumake.dvi
.I
The GNU Make Manual
.PD
.SH BUGS
See the chapter `Problems and Bugs' in
.I "The GNU Make Manual" .
.SH AUTHOR
This manual page contributed by Dennis Morse of Stanford University.
It has been reworked by Roland McGrath.
