#
# md		Enable or disable multiple devices. If /etc/mdtab doesn't
#		exist or is empty we don't bother; likewise if mdadd or
#		mdstop isn't installed.
#
#		Note that since this is called early in the bootprocess you
#		can't swap to an MD device; but you don't want to do that
#		anyway as the Linux kernel can stripe swap partitions
#		itself (see swapon manpage).
#
# Version:	@(#)md  2.57  26-Nov-1997  miquels@cistron.nl
#

case "$arg" in
	start|"")
		if [ -s /etc/mdtab -a -f /sbin/mdadd ]
		then
			mdadd -ar
		fi
		: ;;
	stop)
		if [ -r /etc/mdtab -a -x /sbin/mdstop ]
		then
        		/sbin/mdstop -a
		fi
		: ;;
	*)
		echo "Usage: md [start] [stop]" >&2
		false
		;;
esac

