/*
 * screen.h: header for screen.c
 *
 * written by matthew green.
 *
 * copyright (c) 1993, 1994.
 *
 * see the copyright file, or type help ircii copyright
 *
 * @(#)$Id: screen.h,v 1.14 1995/09/03 13:45:23 mrg Exp $
 */

#ifndef __screen_h_
#define __screen_h_

#include "window.h"

#define WAIT_PROMPT_LINE        0x01
#define WAIT_PROMPT_KEY         0x02

/* Stuff for the screen/xterm junk */

#define ST_NOTHING      -1
#define ST_SCREEN       0
#define ST_XTERM        1

/* This is here because it happens in so many places */
#define curr_scr_win	current_screen->current_window

	void	clear_window _((Window *));
	int	output_line _((register unsigned char *));
	Window	*create_additional_screen _((void));
	void	scroll_window _((Window *));
	void	update_all_windows _((void));
	void	add_wait_prompt _((char *, void (*) (char *, char *), char *, int, int));
	void	clear_all_windows _((int));
	void	cursor_in_display _((void));
	int	is_cursor_in_display _((Screen *));
	void	cursor_not_in_display _((void));
	void	set_current_screen _((Screen *));
	void	window_redirect _((char *, int));
	void	redraw_resized _((Window *, ShrinkInfo, int));
	void	close_all_screen _((void));
	void	scrollback_forwards _((char, char *));
	void	scrollback_backwards _((char, char *));
	void	scrollback_end _((char, char *));
	void	scrollback_start _((char, char *));
RETSIGTYPE	sig_refresh_screen _((int));
	int	check_screen_redirect _((char *));
	void	kill_screen _((Screen *));
	int	rite _((Window *, const unsigned char *));
	ShrinkInfo	resize_display _((Window *));
	void	redraw_window _((Window *, int));
	void	redraw_all_windows _((void));
	void	add_to_screen _((unsigned char *));
	void	do_screens _((fd_set *));
	unsigned	char	**split_up_line(const unsigned char *, int);
	void	xterm_settitle(void);

Screen  * create_new_screen(void);
			
extern	Screen	*main_screen;
extern	Screen	*last_input_screen;
extern	Screen	*screen_list;
extern	Screen	*output_screen;

#endif /* __screen_h_ */
