#!/bin/sh
# Netscape and other programs demand obsolete g++/stdc++ libs,
# so we will fake them:
if [ ! -r usr/lib/libg++.so.27 ]; then
( cd usr/ix86-linux/lib ; rm -rf libstdc++.so.27 )
( cd usr/ix86-linux/lib ; ln -sf /usr/lib/libstdc++.so.2.8 libstdc++.so.27 )
( cd usr/ix86-linux/lib ; rm -rf libg++.so.27 )
( cd usr/ix86-linux/lib ; ln -sf /usr/lib/libstdc++.so.2.8 libg++.so.27 )
fi
cd lib/incoming
for lib in * ; do # if this file is already in /lib, we won't replace it
                  # since it might be in use.
if [ ! -r ../$lib ]; then
  mv $lib ..
fi
done
cd ..
if [ -x /sbin/ldconfig ]; then # update library links
  /sbin/ldconfig .
else # no ldconfig, we must be running safely from the bootdisk.
  rm -f libc.so.5
  ln -sf libc.so.5.4.46 libc.so.5
  rm -f libm.so.5
  ln -sf libm.so.5.0.9 libm.so.5
  rm -f libcurses.so.1
  ln -sf libcurses.so.1.0.0 libcurses.so.1
  rm -f libtermcap.so.2
  ln -sf libtermcap.so.2.0.8 libtermcap.so.2
  rm -f libgdbm.so.1
  ln -sf libgdbm.so.1.7.3 libgdbm.so.1
fi
# Get rid of the /lib/incoming directory:
rm -rf incoming
cd ..
( cd lib ; rm -rf libncurses.so.3.0 )
( cd lib ; ln -sf libncurses.so.3.4 libncurses.so.3.0 )
( cd lib ; rm -rf libncurses.so.3.4 )
( cd lib ; ln -sf libncurses.so.1.9.9g libncurses.so.3.4 )
( cd usr/lib ; rm -rf libstdc++.so.2.8 )
( cd usr/lib ; ln -sf libstdc++.so.2.8.0 libstdc++.so.2.8 )
( cd usr/lib ; rm -rf libdb.so.1 )
( cd usr/lib ; ln -sf libdb.so.1.85.4 libdb.so.1 )
